/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import net.sf.json.JSONObject;
import org.acegisecurity.GrantedAuthority;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class LastGrantedAuthoritiesProperty
extends UserProperty {
    private volatile String[] roles;
    private long timestamp;
    private static final Logger LOGGER = Logger.getLogger(LastGrantedAuthoritiesProperty.class.getName());

    @Override
    public UserProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        req.bindJSON((Object)this, form);
        return this;
    }

    public Collection<? extends org.springframework.security.core.GrantedAuthority> getAuthorities2() {
        String[] roles = this.roles;
        if (roles == null) {
            return Collections.singleton(SecurityRealm.AUTHENTICATED_AUTHORITY2);
        }
        String authenticatedRole = SecurityRealm.AUTHENTICATED_AUTHORITY2.getAuthority();
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>(roles.length + 1);
        grantedAuthorities.add(new SimpleGrantedAuthority(authenticatedRole));
        for (String role : roles) {
            if (authenticatedRole.equals(role)) continue;
            grantedAuthorities.add(new SimpleGrantedAuthority(role));
        }
        return grantedAuthorities;
    }

    @Deprecated
    public GrantedAuthority[] getAuthorities() {
        return GrantedAuthority.fromSpring(this.getAuthorities2());
    }

    @Restricted(value={NoExternalUse.class})
    public void update(@NonNull Authentication auth) throws IOException {
        ArrayList<String> roles = new ArrayList<String>();
        for (org.springframework.security.core.GrantedAuthority ga : auth.getAuthorities()) {
            roles.add(ga.getAuthority());
        }
        Object[] a = roles.toArray(new String[0]);
        if (!Arrays.equals(this.roles, a)) {
            this.roles = a;
            this.timestamp = System.currentTimeMillis();
            this.user.save();
        }
    }

    public void invalidate() throws IOException {
        if (this.roles != null) {
            this.roles = null;
            this.timestamp = System.currentTimeMillis();
            this.user.save();
        }
    }

    @Extension
    @Symbol(value={"lastGrantedAuthorities"})
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public UserProperty newInstance(User user) {
            return null;
        }
    }

    @Extension
    public static class SecurityListenerImpl
    extends SecurityListener {
        @Override
        protected void loggedIn(@NonNull String username) {
            try {
                Authentication a;
                User u = User.getById(username, true);
                LastGrantedAuthoritiesProperty o = u.getProperty(LastGrantedAuthoritiesProperty.class);
                if (o == null) {
                    o = new LastGrantedAuthoritiesProperty();
                    u.addProperty(o);
                }
                if ((a = Jenkins.getAuthentication2()) != null && a.getName().equals(username)) {
                    o.update(a);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to record granted authorities", e);
            }
        }

        @Override
        protected void failedToLogIn(@NonNull String username) {
        }
    }
}

