/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.FullControlOnceLoggedInAuthorizationStrategy;
import hudson.security.LegacyAuthorizationStrategy;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.Messages;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import jenkins.security.QueueItemAuthenticatorDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.core.Authentication;

@Extension
@Restricted(value={NoExternalUse.class})
public class QueueItemAuthenticatorMonitor
extends AdministrativeMonitor {
    private static boolean anyBuildLaunchedAsSystemWithAuthenticatorPresent = false;
    private static final Logger LOGGER = Logger.getLogger(QueueItemAuthenticatorMonitor.class.getName());

    @Override
    public boolean isActivated() {
        AuthorizationStrategy authorizationStrategy = Jenkins.get().getAuthorizationStrategy();
        if (authorizationStrategy instanceof AuthorizationStrategy.Unsecured) {
            return false;
        }
        if (authorizationStrategy instanceof LegacyAuthorizationStrategy) {
            return false;
        }
        if (authorizationStrategy instanceof FullControlOnceLoggedInAuthorizationStrategy) {
            return false;
        }
        return !QueueItemAuthenticatorMonitor.isQueueItemAuthenticatorPresent() || !QueueItemAuthenticatorMonitor.isQueueItemAuthenticatorConfigured() || this.isAnyBuildLaunchedAsSystemWithAuthenticatorPresent();
    }

    @Override
    public boolean isSecurity() {
        return true;
    }

    @RequirePOST
    public HttpResponse doAct(@QueryParameter String redirect, @QueryParameter String dismiss, @QueryParameter String reset) throws IOException {
        if (redirect != null) {
            return HttpResponses.redirectTo((String)"https://www.jenkins.io/redirect/queue-item-security");
        }
        if (dismiss != null) {
            this.disable(true);
        }
        if (reset != null) {
            anyBuildLaunchedAsSystemWithAuthenticatorPresent = false;
        }
        return HttpResponses.forwardToPreviousPage();
    }

    public static boolean isQueueItemAuthenticatorPresent() {
        return !QueueItemAuthenticatorDescriptor.all().isEmpty();
    }

    public static boolean isQueueItemAuthenticatorConfigured() {
        return !QueueItemAuthenticatorConfiguration.get().getAuthenticators().isEmpty();
    }

    public boolean isAnyBuildLaunchedAsSystemWithAuthenticatorPresent() {
        return anyBuildLaunchedAsSystemWithAuthenticatorPresent;
    }

    @Override
    public String getDisplayName() {
        return Messages.QueueItemAuthenticatorMonitor_DisplayName();
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class QueueListenerImpl
    extends QueueListener {
        @Override
        public void onLeft(Queue.LeftItem li) {
            if (li.isCancelled()) {
                return;
            }
            String displayName = li.getDisplayName();
            if (displayName == null && li.task != null) {
                displayName = li.task.getFullDisplayName();
            }
            Queue.Executable executable = li.getExecutable();
            if (displayName == null && executable != null) {
                displayName = executable.toString();
            }
            if (!(li.task instanceof Job)) {
                LOGGER.log(Level.FINE, displayName + " is not a job");
                return;
            }
            Authentication buildAuthentication = li.authenticate2();
            boolean buildRunsAsSystem = buildAuthentication.equals(ACL.SYSTEM2);
            if (!buildRunsAsSystem) {
                LOGGER.log(Level.FINE, displayName + " does not run as SYSTEM");
                return;
            }
            LOGGER.log(Level.FINE, displayName + " is running as SYSTEM");
            if (QueueItemAuthenticatorMonitor.isQueueItemAuthenticatorConfigured()) {
                anyBuildLaunchedAsSystemWithAuthenticatorPresent = true;
            }
        }
    }
}

