/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import java.io.IOException;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.security.s2m.AdminWhitelistRule;
import jenkins.security.s2m.Messages;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"slaveToMasterAccessControl"})
public class AdminCallableMonitor
extends AdministrativeMonitor {
    @Inject
    Jenkins jenkins;
    @Inject
    AdminWhitelistRule rule;

    public AdminCallableMonitor() {
        super("slaveToMasterAccessControl");
    }

    @Override
    public boolean isSecurity() {
        return true;
    }

    @Override
    public boolean isActivated() {
        return !this.rule.rejected.describe().isEmpty();
    }

    @Override
    public String getDisplayName() {
        return Messages.AdminCallableMonitor_DisplayName();
    }

    public AdminWhitelistRule getRule() {
        return this.rule;
    }

    @RequirePOST
    public HttpResponse doAct(@QueryParameter String dismiss) throws IOException {
        if (dismiss != null) {
            this.disable(true);
            return HttpResponses.redirectViaContextPath((String)"/manage");
        }
        return HttpResponses.redirectTo((String)"rule/");
    }

    public HttpResponse doIndex() {
        return HttpResponses.redirectTo((String)"rule/");
    }
}

