/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import hudson.Functions;
import hudson.model.Failure;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.security.s2m.ConfigDirectory;
import jenkins.security.s2m.FilePathRule;
import jenkins.security.s2m.OpMatcher;

class FilePathRuleConfig
extends ConfigDirectory<FilePathRule, List<FilePathRule>> {
    private static final Logger LOGGER = Logger.getLogger(FilePathRuleConfig.class.getName());
    private static final Pattern PARSER = Pattern.compile("(allow|deny)\\s+([a-z,]+)\\s+(.*)");

    FilePathRuleConfig(File file) {
        super(file);
    }

    @Override
    protected List<FilePathRule> create() {
        return new ArrayList<FilePathRule>();
    }

    @Override
    protected List<FilePathRule> readOnly(List<FilePathRule> base) {
        return Collections.unmodifiableList(new ArrayList<FilePathRule>(base));
    }

    @Override
    protected FilePathRule parse(String line) {
        Matcher m;
        if ((line = line.trim()).isEmpty()) {
            return null;
        }
        line = line.replace("<BUILDDIR>", "<JOBDIR>/builds/[0-9]+");
        line = line.replace("<BUILDID>", "(?:[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]_[0-9][0-9]-[0-9][0-9]-[0-9][0-9]|[0-9]+)");
        line = line.replace("<JOBDIR>", "<JENKINS_HOME>/jobs/.+");
        File jenkinsHome = Jenkins.get().getRootDir();
        try {
            line = line.replace("<JENKINS_HOME>", "\\Q" + jenkinsHome.getCanonicalPath() + "\\E");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e, () -> "Failed to determine canonical path to Jenkins home directory, falling back to configured value: " + jenkinsHome.getPath());
            line = line.replace("<JENKINS_HOME>", "\\Q" + jenkinsHome.getPath() + "\\E");
        }
        if (Functions.isWindows()) {
            line = line.replace("/", "\\\\");
        }
        if (!(m = PARSER.matcher(line)).matches()) {
            throw new Failure("Invalid filter rule line: " + line);
        }
        try {
            return new FilePathRule(Pattern.compile(m.group(3)), this.createOpMatcher(m.group(2)), m.group(1).equals("allow"));
        }
        catch (Exception e) {
            throw new Failure("Invalid filter rule line: " + line + "\n" + Functions.printThrowable(e));
        }
    }

    private OpMatcher createOpMatcher(String token) {
        if (token.equals("all")) {
            return OpMatcher.ALL;
        }
        final Set<String> ops = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(token.split(","))));
        return new OpMatcher(){

            @Override
            public boolean matches(String op) {
                return ops.contains(op);
            }
        };
    }

    public boolean checkFileAccess(String op, File path) throws SecurityException {
        String pathStr = null;
        for (FilePathRule rule : (List)this.get()) {
            if (!rule.op.matches(op)) continue;
            if (pathStr == null) {
                try {
                    pathStr = path.getCanonicalPath();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                if (Functions.isWindows()) {
                    pathStr = pathStr.replace('/', '\\');
                }
            }
            if (!rule.path.matcher(pathStr).matches()) continue;
            return rule.allow;
        }
        return false;
    }
}

