/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.seed;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.User;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.SecurityListener;
import org.apache.tools.ant.ExtensionPoint;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class UserSeedChangeListener
extends ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(SecurityListener.class.getName());

    public abstract void onUserSeedRenewed(@NonNull User var1);

    public static void fireUserSeedRenewed(@NonNull User user) {
        for (UserSeedChangeListener l : UserSeedChangeListener.all()) {
            try {
                l.onUserSeedRenewed(user);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception caught during onUserSeedRenewed event", e);
            }
        }
    }

    private static List<UserSeedChangeListener> all() {
        return ExtensionList.lookup(UserSeedChangeListener.class);
    }
}

