/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionComponent;
import hudson.ExtensionFinder;
import hudson.FilePath;
import hudson.Plugin;
import hudson.PluginFirstClassLoader;
import hudson.PluginFirstClassLoader2;
import hudson.PluginManager;
import hudson.PluginStrategy;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.model.Hudson;
import hudson.util.CyclicGraphDetector;
import hudson.util.IOUtils;
import hudson.util.MaskingClassLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.ClassLoaderReflectionToolkit;
import jenkins.ExtensionFilter;
import jenkins.plugins.DetachedPluginsUtil;
import jenkins.util.AntClassLoader;
import jenkins.util.SystemProperties;
import jenkins.util.URLClassLoader2;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.resources.MappedResourceCollection;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipOutputStream;

public class ClassicPluginStrategy
implements PluginStrategy {
    private static final Logger LOGGER = Logger.getLogger(ClassicPluginStrategy.class.getName());
    private static final FilenameFilter JAR_FILTER = (dir, name) -> name.endsWith(".jar");
    private final PluginManager pluginManager;
    private final MaskingClassLoader coreClassLoader = new MaskingClassLoader(this.getClass().getClassLoader(), new String[0]);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean useAntClassLoader = SystemProperties.getBoolean(ClassicPluginStrategy.class.getName() + ".useAntClassLoader");

    public ClassicPluginStrategy(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    @Override
    public String getShortName(File archive) throws IOException {
        Manifest manifest;
        if (!archive.exists()) {
            throw new FileNotFoundException("Failed to load " + archive + ". The file does not exist");
        }
        if (!archive.isFile()) {
            throw new FileNotFoundException("Failed to load " + archive + ". It is not a file");
        }
        if (ClassicPluginStrategy.isLinked(archive)) {
            manifest = ClassicPluginStrategy.loadLinkedManifest(archive);
        } else {
            try (JarFile jf = new JarFile(archive, false);){
                manifest = jf.getManifest();
            }
            catch (IOException ex) {
                throw new IOException("Failed to load " + archive, ex);
            }
        }
        return PluginWrapper.computeShortName(manifest, archive.getName());
    }

    private static boolean isLinked(File archive) {
        return archive.getName().endsWith(".hpl") || archive.getName().endsWith(".jpl");
    }

    private static Manifest loadLinkedManifest(File archive) throws IOException {
        Manifest manifest;
        block21: {
            String firstLine;
            try (InputStream manifestHeaderInput = Files.newInputStream(archive.toPath(), new OpenOption[0]);){
                firstLine = IOUtils.readFirstLine(manifestHeaderInput, "UTF-8");
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            if (!firstLine.startsWith("Manifest-Version:")) {
                archive = ClassicPluginStrategy.resolve(archive, firstLine);
            }
            InputStream manifestInput = Files.newInputStream(archive.toPath(), new OpenOption[0]);
            try {
                manifest = new Manifest(manifestInput);
                if (manifestInput == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (manifestInput != null) {
                            try {
                                manifestInput.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidPathException e) {
                        throw new IOException(e);
                    }
                }
                catch (IOException e) {
                    throw new IOException("Failed to load " + archive, e);
                }
            }
            manifestInput.close();
        }
        return manifest;
    }

    @Override
    public PluginWrapper createPluginWrapper(File archive) throws IOException {
        URL baseResourceURL;
        Manifest manifest;
        File expandDir = null;
        boolean isLinked = ClassicPluginStrategy.isLinked(archive);
        if (isLinked) {
            manifest = ClassicPluginStrategy.loadLinkedManifest(archive);
        } else {
            if (archive.isDirectory()) {
                expandDir = archive;
            } else {
                File f = this.pluginManager.getWorkDir();
                expandDir = new File(f == null ? archive.getParentFile() : f, FilenameUtils.getBaseName((String)archive.getName()));
                ClassicPluginStrategy.explode(archive, expandDir);
            }
            File manifestFile = new File(expandDir, "META-INF/MANIFEST.MF");
            if (!manifestFile.exists()) {
                throw new IOException("Plugin installation failed. No manifest at " + manifestFile);
            }
            try (InputStream fin = Files.newInputStream(manifestFile.toPath(), new OpenOption[0]);){
                manifest = new Manifest(fin);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            String canonicalName = manifest.getMainAttributes().getValue("Short-Name") + ".jpi";
            if (!archive.getName().equals(canonicalName)) {
                LOGGER.warning(() -> "encountered " + archive + " under a nonstandard name; expected " + canonicalName);
            }
        }
        Attributes atts = manifest.getMainAttributes();
        ArrayList<File> paths = new ArrayList<File>();
        if (isLinked) {
            ClassicPluginStrategy.parseClassPath(manifest, archive, paths, "Libraries", ",");
            ClassicPluginStrategy.parseClassPath(manifest, archive, paths, "Class-Path", " +");
            baseResourceURL = ClassicPluginStrategy.resolve(archive, atts.getValue("Resource-Path")).toURI().toURL();
        } else {
            File lib;
            File[] libs;
            File classes = new File(expandDir, "WEB-INF/classes");
            if (classes.exists()) {
                LOGGER.log(Level.WARNING, "Deprecated unpacked classes directory found in {0}", classes);
                paths.add(classes);
            }
            if ((libs = (lib = new File(expandDir, "WEB-INF/lib")).listFiles(JAR_FILTER)) != null) {
                paths.addAll(Arrays.asList(libs));
            }
            baseResourceURL = expandDir.toPath().toUri().toURL();
        }
        File disableFile = new File(archive.getPath() + ".disabled");
        if (disableFile.exists()) {
            LOGGER.info("Plugin " + archive.getName() + " is disabled");
        }
        if (paths.isEmpty()) {
            LOGGER.info("No classpaths found for plugin " + archive.getName());
        }
        ArrayList<PluginWrapper.Dependency> dependencies = new ArrayList<PluginWrapper.Dependency>();
        ArrayList<PluginWrapper.Dependency> optionalDependencies = new ArrayList<PluginWrapper.Dependency>();
        String v = atts.getValue("Plugin-Dependencies");
        if (v != null) {
            for (String s : v.split(",")) {
                PluginWrapper.Dependency d = new PluginWrapper.Dependency(s);
                if (d.optional) {
                    optionalDependencies.add(d);
                    continue;
                }
                dependencies.add(d);
            }
        }
        this.fix(atts, optionalDependencies);
        String masked = atts.getValue("Global-Mask-Classes");
        if (masked != null) {
            for (String pkg : masked.trim().split("[ \t\r\n]+")) {
                this.coreClassLoader.add(pkg);
            }
        }
        ClassLoader dependencyLoader = new DependencyClassLoader(this.coreClassLoader, archive, Util.join(dependencies, optionalDependencies), this.pluginManager);
        dependencyLoader = this.getBaseClassLoader(atts, dependencyLoader);
        return new PluginWrapper(this.pluginManager, archive, manifest, baseResourceURL, this.createClassLoader(paths, dependencyLoader, atts), disableFile, dependencies, optionalDependencies);
    }

    private void fix(Attributes atts, List<PluginWrapper.Dependency> optionalDependencies) {
        String pluginName = atts.getValue("Short-Name");
        String jenkinsVersion = atts.getValue("Jenkins-Version");
        if (jenkinsVersion == null) {
            jenkinsVersion = atts.getValue("Hudson-Version");
        }
        for (PluginWrapper.Dependency d : DetachedPluginsUtil.getImpliedDependencies(pluginName, jenkinsVersion)) {
            LOGGER.fine(() -> "implied dep " + pluginName + " \u2192 " + d.shortName);
            this.pluginManager.considerDetachedPlugin(d.shortName);
            optionalDependencies.add(d);
        }
    }

    @Deprecated
    @NonNull
    public static List<PluginWrapper.Dependency> getImpliedDependencies(String pluginName, String jenkinsVersion) {
        return DetachedPluginsUtil.getImpliedDependencies(pluginName, jenkinsVersion);
    }

    @Deprecated
    protected ClassLoader createClassLoader(List<File> paths, ClassLoader parent) throws IOException {
        return this.createClassLoader(paths, parent, null);
    }

    protected ClassLoader createClassLoader(List<File> paths, ClassLoader parent, Attributes atts) throws IOException {
        boolean usePluginFirstClassLoader;
        boolean bl = usePluginFirstClassLoader = atts != null && Boolean.parseBoolean(atts.getValue("PluginFirstClassLoader"));
        if (useAntClassLoader) {
            AntClassLoader classLoader;
            if (usePluginFirstClassLoader) {
                classLoader = new PluginFirstClassLoader();
                classLoader.setParentFirst(false);
                classLoader.setParent(parent);
            } else {
                classLoader = new AntClassLoader(parent, true);
            }
            classLoader.addPathFiles(paths);
            return classLoader;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File path : paths) {
            urls.add(path.toURI().toURL());
        }
        URLClassLoader2 classLoader = usePluginFirstClassLoader ? new PluginFirstClassLoader2(urls.toArray(new URL[0]), parent) : new URLClassLoader2(urls.toArray(new URL[0]), parent);
        return classLoader;
    }

    private ClassLoader getBaseClassLoader(Attributes atts, ClassLoader base) {
        String masked = atts.getValue("Mask-Classes");
        if (masked != null) {
            base = new MaskingClassLoader(base, masked.trim().split("[ \t\r\n]+"));
        }
        return base;
    }

    @Override
    public void initializeComponents(PluginWrapper plugin) {
    }

    @Override
    public <T> List<ExtensionComponent<T>> findComponents(Class<T> type, Hudson hudson) {
        List<ExtensionFinder> finders = type == ExtensionFinder.class ? List.of(new ExtensionFinder.Sezpoz()) : hudson.getExtensionList(ExtensionFinder.class);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Scout-loading ExtensionList: " + type, new Throwable());
        }
        for (ExtensionFinder extensionFinder : finders) {
            extensionFinder.scout(type, hudson);
        }
        ArrayList<ExtensionComponent<T>> r = new ArrayList<ExtensionComponent<T>>();
        for (ExtensionFinder finder : finders) {
            try {
                r.addAll(finder.find(type, hudson));
            }
            catch (AbstractMethodError abstractMethodError) {
                for (T t : finder.findExtensions(type, hudson)) {
                    r.add(new ExtensionComponent<T>(t));
                }
            }
        }
        ArrayList<ExtensionComponent<T>> arrayList = new ArrayList<ExtensionComponent<T>>();
        for (ExtensionComponent extensionComponent : r) {
            if (!ExtensionFilter.isAllowed(type, extensionComponent)) continue;
            arrayList.add(extensionComponent);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(PluginWrapper wrapper) throws IOException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wrapper.classLoader);
        try {
            String className = wrapper.getPluginClass();
            if (className == null) {
                wrapper.setPlugin(new Plugin.DummyImpl());
            } else {
                try {
                    Class<?> clazz = wrapper.classLoader.loadClass(className);
                    Object o = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!(o instanceof Plugin)) {
                        throw new IOException(className + " doesn't extend from hudson.Plugin");
                    }
                    wrapper.setPlugin((Plugin)o);
                }
                catch (ClassNotFoundException | LinkageError e) {
                    throw new IOException("Unable to load " + className + " from " + wrapper.getShortName(), e);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IOException("Unable to create instance of " + className + " from " + wrapper.getShortName(), e);
                }
            }
            try {
                Plugin plugin = wrapper.getPluginOrFail();
                plugin.setServletContext(this.pluginManager.context);
                this.startPlugin(wrapper);
            }
            catch (Throwable t) {
                throw new IOException("Failed to initialize", t);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void startPlugin(PluginWrapper plugin) throws Exception {
        plugin.getPluginOrFail().start();
    }

    @Override
    public void updateDependency(PluginWrapper depender, PluginWrapper dependee) {
        DependencyClassLoader classLoader = this.findAncestorDependencyClassLoader(depender.classLoader);
        if (classLoader != null) {
            classLoader.updateTransitiveDependencies();
            LOGGER.log(Level.INFO, "Updated dependency of {0}", depender.getShortName());
        }
    }

    private DependencyClassLoader findAncestorDependencyClassLoader(ClassLoader classLoader) {
        while (classLoader != null) {
            DependencyClassLoader ret;
            if (classLoader instanceof DependencyClassLoader) {
                return (DependencyClassLoader)classLoader;
            }
            if (classLoader instanceof AntClassLoader && (ret = this.findAncestorDependencyClassLoader(((AntClassLoader)((Object)classLoader)).getConfiguredParent())) != null) {
                return ret;
            }
            classLoader = classLoader.getParent();
        }
        return null;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Administrator action installing a plugin, which could do far worse.")
    private static File resolve(File base, String relative) {
        File rel = new File(relative);
        if (rel.isAbsolute()) {
            return rel;
        }
        return new File(base.getParentFile(), relative);
    }

    private static void parseClassPath(Manifest manifest, File archive, List<File> paths, String attributeName, String separator) throws IOException {
        String classPath = manifest.getMainAttributes().getValue(attributeName);
        if (classPath == null) {
            return;
        }
        for (String s : classPath.split(separator)) {
            File file = ClassicPluginStrategy.resolve(archive, s);
            if (file.getName().contains("*")) {
                FileSet fs = new FileSet();
                File dir = file.getParentFile();
                fs.setDir(dir);
                fs.setIncludes(file.getName());
                for (String included : fs.getDirectoryScanner(new Project()).getIncludedFiles()) {
                    paths.add(new File(dir, included));
                }
                continue;
            }
            if (!file.exists()) {
                throw new IOException("No such file: " + file);
            }
            paths.add(file);
        }
    }

    private static void explode(File archive, File destDir) throws IOException {
        Util.createDirectories(Util.fileToPath(destDir), new FileAttribute[0]);
        File explodeTime = new File(destDir, ".timestamp2");
        if (explodeTime.exists() && explodeTime.lastModified() == archive.lastModified()) {
            return;
        }
        Util.deleteRecursive(destDir);
        try {
            Project prj = new Project();
            ClassicPluginStrategy.unzipExceptClasses(archive, destDir, prj);
            ClassicPluginStrategy.createClassJarFromWebInfClasses(archive, destDir, prj);
        }
        catch (BuildException x) {
            throw new IOException("Failed to expand " + archive, x);
        }
        try {
            new FilePath(explodeTime).touch(archive.lastModified());
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void createClassJarFromWebInfClasses(File archive, File destDir, Project prj) throws IOException {
        File classesJar = new File(destDir, "WEB-INF/lib/classes.jar");
        ZipFileSet zfs = new ZipFileSet();
        zfs.setProject(prj);
        zfs.setSrc(archive);
        zfs.setIncludes("WEB-INF/classes/");
        MappedResourceCollection mapper = new MappedResourceCollection();
        mapper.add((ResourceCollection)zfs);
        GlobPatternMapper gm = new GlobPatternMapper();
        gm.setFrom("WEB-INF/classes/*");
        gm.setTo("*");
        mapper.add((FileNameMapper)gm);
        final long dirTime = archive.lastModified();
        try (final ZipOutputStream wrappedZOut = new ZipOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM){

            public void putNextEntry(ZipEntry ze) throws IOException {
                ze.setTime(dirTime + 1999L);
                super.putNextEntry(ze);
            }
        };){
            Zip z = new Zip(){

                protected void zipDir(Resource dir, ZipOutputStream zOut, String vPath, int mode, ZipExtraField[] extra) throws IOException {
                    super.zipDir(dir, wrappedZOut, vPath, mode, extra);
                }
            };
            z.setProject(prj);
            z.setTaskType("zip");
            Util.createDirectories(Util.fileToPath(classesJar.getParentFile()), new FileAttribute[0]);
            z.setDestFile(classesJar);
            z.add((ResourceCollection)mapper);
            z.execute();
        }
        if (classesJar.isFile()) {
            LOGGER.log(Level.WARNING, "Created {0}; update plugin to a version created with a newer harness", classesJar);
        }
    }

    private static void unzipExceptClasses(File archive, File destDir, Project prj) {
        Expand e = new Expand();
        e.setProject(prj);
        e.setTaskType("unzip");
        e.setSrc(archive);
        e.setDest(destDir);
        PatternSet p = new PatternSet();
        p.setExcludes("WEB-INF/classes/");
        e.addPatternset(p);
        e.execute();
    }

    static final class DependencyClassLoader
    extends ClassLoader {
        private final File _for;
        private List<PluginWrapper.Dependency> dependencies;
        private final PluginManager pluginManager;
        private volatile List<PluginWrapper> transitiveDependencies;

        DependencyClassLoader(ClassLoader parent, File archive, List<PluginWrapper.Dependency> dependencies, PluginManager pluginManager) {
            super(parent);
            this._for = archive;
            this.dependencies = List.copyOf(dependencies);
            this.pluginManager = pluginManager;
        }

        private void updateTransitiveDependencies() {
            this.transitiveDependencies = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<PluginWrapper> getTransitiveDependencies() {
            List<PluginWrapper> localTransitiveDependencies = this.transitiveDependencies;
            if (localTransitiveDependencies == null) {
                DependencyClassLoader dependencyClassLoader = this;
                synchronized (dependencyClassLoader) {
                    localTransitiveDependencies = this.transitiveDependencies;
                    if (localTransitiveDependencies == null) {
                        CyclicGraphDetector<PluginWrapper> cgd = new CyclicGraphDetector<PluginWrapper>(){

                            @Override
                            protected List<PluginWrapper> getEdges(PluginWrapper pw) {
                                ArrayList<PluginWrapper> dep = new ArrayList<PluginWrapper>();
                                for (PluginWrapper.Dependency d : pw.getDependencies()) {
                                    PluginWrapper p = pluginManager.getPlugin(d.shortName);
                                    if (p == null || !p.isActive()) continue;
                                    dep.add(p);
                                }
                                return dep;
                            }
                        };
                        try {
                            for (PluginWrapper.Dependency d : this.dependencies) {
                                PluginWrapper p = this.pluginManager.getPlugin(d.shortName);
                                if (p == null || !p.isActive()) continue;
                                cgd.run(Set.of(p));
                            }
                        }
                        catch (CyclicGraphDetector.CycleDetectedException e) {
                            throw new AssertionError((Object)e);
                        }
                        this.transitiveDependencies = localTransitiveDependencies = cgd.getSorted();
                    }
                }
            }
            return localTransitiveDependencies;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (PluginManager.FAST_LOOKUP) {
                for (PluginWrapper pw : this.getTransitiveDependencies()) {
                    try {
                        return ClassLoaderReflectionToolkit.loadClass(pw.classLoader, name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            } else {
                for (PluginWrapper.Dependency dep : this.dependencies) {
                    PluginWrapper p = this.pluginManager.getPlugin(dep.shortName);
                    if (p == null) continue;
                    try {
                        return p.classLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        @SuppressFBWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="Should not produce network overheads since the URL is local. JENKINS-53793 is a follow-up")
        protected Enumeration<URL> findResources(String name) throws IOException {
            HashSet<URL> result = new HashSet<URL>();
            if (PluginManager.FAST_LOOKUP) {
                for (PluginWrapper pw : this.getTransitiveDependencies()) {
                    Enumeration<URL> urls = ClassLoaderReflectionToolkit._findResources(pw.classLoader, name);
                    while (urls != null && urls.hasMoreElements()) {
                        result.add(urls.nextElement());
                    }
                }
            } else {
                for (PluginWrapper.Dependency dep : this.dependencies) {
                    PluginWrapper p = this.pluginManager.getPlugin(dep.shortName);
                    if (p == null) continue;
                    Enumeration<URL> urls = p.classLoader.getResources(name);
                    while (urls != null && urls.hasMoreElements()) {
                        result.add(urls.nextElement());
                    }
                }
            }
            return Collections.enumeration(result);
        }

        @Override
        protected URL findResource(String name) {
            if (PluginManager.FAST_LOOKUP) {
                for (PluginWrapper pw : this.getTransitiveDependencies()) {
                    URL url = ClassLoaderReflectionToolkit._findResource(pw.classLoader, name);
                    if (url == null) continue;
                    return url;
                }
            } else {
                for (PluginWrapper.Dependency dep : this.dependencies) {
                    URL url;
                    PluginWrapper p = this.pluginManager.getPlugin(dep.shortName);
                    if (p == null || (url = p.classLoader.getResource(name)) == null) continue;
                    return url;
                }
            }
            return null;
        }

        static {
            DependencyClassLoader.registerAsParallelCapable();
        }
    }
}

