/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Functions;
import hudson.Messages;
import hudson.RestrictedSince;
import hudson.model.TaskListener;
import hudson.util.QuotedStringTokenizer;
import hudson.util.VariableResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import jenkins.util.MemoryReductionUtil;
import jenkins.util.SystemProperties;
import jenkins.util.io.PathRemover;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

public class Util {
    private static final long ONE_SECOND_MS = 1000L;
    private static final long ONE_MINUTE_MS = 60000L;
    private static final long ONE_HOUR_MS = 3600000L;
    private static final long ONE_DAY_MS = 86400000L;
    private static final long ONE_MONTH_MS = 2592000000L;
    private static final long ONE_YEAR_MS = 31536000000L;
    private static final Pattern VARIABLE;
    private static final Pattern errorCodeParser;
    private static final boolean[] uriMap;
    private static final boolean[] fullUriMap;
    private static final AtomicBoolean warnedSymlinks;
    public static final FastDateFormat XS_DATETIME_FORMATTER;
    public static final FastDateFormat RFC822_DATETIME_FORMATTER;
    private static final Logger LOGGER;
    public static boolean NO_SYMLINK;
    public static boolean SYMLINK_ESCAPEHATCH;
    @Restricted(value={NoExternalUse.class})
    static int DELETION_RETRIES;
    @Restricted(value={NoExternalUse.class})
    static int WAIT_BETWEEN_DELETION_RETRIES;
    @Restricted(value={NoExternalUse.class})
    static boolean GC_AFTER_FAILED_DELETE;

    @NonNull
    public static <T> List<T> filter(@NonNull Iterable<?> base, @NonNull Class<T> type) {
        ArrayList<T> r = new ArrayList<T>();
        for (Object i : base) {
            if (!type.isInstance(i)) continue;
            r.add(type.cast(i));
        }
        return r;
    }

    @NonNull
    public static <T> List<T> filter(@NonNull List<?> base, @NonNull Class<T> type) {
        return Util.filter(base, type);
    }

    @Nullable
    public static String replaceMacro(@CheckForNull String s, @NonNull Map<String, String> properties) {
        return Util.replaceMacro(s, new VariableResolver.ByMap<String>(properties));
    }

    @Nullable
    public static String replaceMacro(@CheckForNull String s, @NonNull VariableResolver<String> resolver) {
        if (s == null) {
            return null;
        }
        int idx = 0;
        Matcher m;
        while ((m = VARIABLE.matcher((CharSequence)s)).find(idx)) {
            String value;
            String key = m.group().substring(1);
            if (key.charAt(0) == '$') {
                value = "$";
            } else {
                if (key.charAt(0) == '{') {
                    key = key.substring(1, key.length() - 1);
                }
                value = resolver.resolve(key);
            }
            if (value == null) {
                idx = m.end();
                continue;
            }
            s = ((String)s).substring(0, m.start()) + value + ((String)s).substring(m.end());
            idx = m.start() + value.length();
        }
        return s;
    }

    @Deprecated
    @NonNull
    public static String loadFile(@NonNull File logfile) throws IOException {
        return Util.loadFile(logfile, Charset.defaultCharset());
    }

    @NonNull
    public static String loadFile(@NonNull File logfile, @NonNull Charset charset) throws IOException {
        try {
            return FileUtils.readFileToString((File)logfile, (Charset)charset);
        }
        catch (FileNotFoundException e) {
            return "";
        }
        catch (Exception e) {
            throw new IOException("Failed to fully read " + logfile, e);
        }
    }

    public static void deleteContentsRecursive(@NonNull File file) throws IOException {
        Util.deleteContentsRecursive(Util.fileToPath(file), PathRemover.PathChecker.ALLOW_ALL);
    }

    @Restricted(value={NoExternalUse.class})
    public static void deleteContentsRecursive(@NonNull Path path, @NonNull PathRemover.PathChecker pathChecker) throws IOException {
        Util.newPathRemover(pathChecker).forceRemoveDirectoryContents(path);
    }

    public static void deleteFile(@NonNull File f) throws IOException {
        Util.newPathRemover(PathRemover.PathChecker.ALLOW_ALL).forceRemoveFile(Util.fileToPath(f));
    }

    public static void deleteRecursive(@NonNull File dir) throws IOException {
        Util.deleteRecursive(Util.fileToPath(dir), PathRemover.PathChecker.ALLOW_ALL);
    }

    @Restricted(value={NoExternalUse.class})
    public static void deleteRecursive(@NonNull Path dir, @NonNull PathRemover.PathChecker pathChecker) throws IOException {
        Util.newPathRemover(pathChecker).forceRemoveRecursive(dir);
    }

    public static boolean isSymlink(@NonNull File file) throws IOException {
        return Util.isSymlink(Util.fileToPath(file));
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean isSymlink(@NonNull Path path) {
        try {
            BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            return attrs.isSymbolicLink() || attrs instanceof DosFileAttributes && attrs.isOther();
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isRelativePath(String path) {
        char p;
        if (path.startsWith("/")) {
            return false;
        }
        if (path.startsWith("\\\\") && path.length() > 3 && path.indexOf(92, 3) != -1) {
            return false;
        }
        if (path.length() >= 3 && ':' == path.charAt(1) && ('A' <= (p = path.charAt(0)) && p <= 'Z' || 'a' <= p && p <= 'z')) {
            return path.charAt(2) != '\\' && path.charAt(2) != '/';
        }
        return true;
    }

    public static boolean isDescendant(File forParent, File potentialChild) throws IOException {
        Path child = Util.fileToPath(potentialChild.getAbsoluteFile()).normalize();
        Path parent = Util.fileToPath(forParent.getAbsoluteFile()).normalize();
        return child.startsWith(parent);
    }

    public static File createTempDir() throws IOException {
        String tempDirNamePrefix = "jenkins";
        Path tempPath = FileSystems.getDefault().supportedFileAttributeViews().contains("posix") ? Files.createTempDirectory("jenkins", PosixFilePermissions.asFileAttribute(EnumSet.allOf(PosixFilePermission.class))) : Files.createTempDirectory("jenkins", new FileAttribute[0]);
        return tempPath.toFile();
    }

    public static void displayIOException(@NonNull IOException e, @NonNull TaskListener listener) {
        String msg = Util.getWin32ErrorMessage(e);
        if (msg != null) {
            listener.getLogger().println(msg);
        }
    }

    @CheckForNull
    public static String getWin32ErrorMessage(@NonNull IOException e) {
        return Util.getWin32ErrorMessage((Throwable)e);
    }

    @CheckForNull
    public static String getWin32ErrorMessage(Throwable e) {
        Matcher m;
        String msg = e.getMessage();
        if (msg != null && (m = errorCodeParser.matcher(msg)).matches()) {
            try {
                ResourceBundle rb = ResourceBundle.getBundle("/hudson/win32errors");
                return rb.getString("error" + m.group(1));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (e.getCause() != null) {
            return Util.getWin32ErrorMessage(e.getCause());
        }
        return null;
    }

    @CheckForNull
    public static String getWin32ErrorMessage(int n) {
        try {
            ResourceBundle rb = ResourceBundle.getBundle("/hudson/win32errors");
            return rb.getString("error" + n);
        }
        catch (MissingResourceException e) {
            LOGGER.log(Level.WARNING, "Failed to find resource bundle", e);
            return null;
        }
    }

    @NonNull
    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    @Deprecated
    public static void copyStream(@NonNull InputStream in, @NonNull OutputStream out) throws IOException {
        IOUtils.copy((InputStream)in, (OutputStream)out);
    }

    @Deprecated
    public static void copyStream(@NonNull Reader in, @NonNull Writer out) throws IOException {
        IOUtils.copy((Reader)in, (Writer)out);
    }

    @Deprecated
    public static void copyStreamAndClose(@NonNull InputStream in, @NonNull OutputStream out) throws IOException {
        try (InputStream _in = in;
             OutputStream _out = out;){
            IOUtils.copy((InputStream)_in, (OutputStream)_out);
        }
    }

    @Deprecated
    public static void copyStreamAndClose(@NonNull Reader in, @NonNull Writer out) throws IOException {
        try (Reader _in = in;
             Writer _out = out;){
            IOUtils.copy((Reader)_in, (Writer)_out);
        }
    }

    @NonNull
    public static String[] tokenize(@NonNull String s, @CheckForNull String delimiter) {
        return QuotedStringTokenizer.tokenize((String)s, (String)delimiter);
    }

    @NonNull
    public static String[] tokenize(@NonNull String s) {
        return Util.tokenize(s, " \t\n\r\f");
    }

    @NonNull
    public static String[] mapToEnv(@NonNull Map<String, String> m) {
        String[] r = new String[m.size()];
        int idx = 0;
        for (Map.Entry<String, String> e : m.entrySet()) {
            r[idx++] = e.getKey() + "=" + e.getValue();
        }
        return r;
    }

    public static int min(int x, int ... values) {
        for (int i : values) {
            if (i >= x) continue;
            x = i;
        }
        return x;
    }

    @CheckForNull
    public static String nullify(@CheckForNull String v) {
        return Util.fixEmpty(v);
    }

    @NonNull
    public static String removeTrailingSlash(@NonNull String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Nullable
    public static String ensureEndsWith(@CheckForNull String subject, @CheckForNull String suffix) {
        if (subject == null) {
            return null;
        }
        if (subject.endsWith(suffix)) {
            return subject;
        }
        return subject + suffix;
    }

    @NonNull
    public static String getDigestOf(@NonNull InputStream source) throws IOException {
        String string;
        block8: {
            InputStream inputStream = source;
            try {
                MessageDigest md5 = Util.getMd5();
                DigestInputStream in = new DigestInputStream(source, md5);
                IOUtils.copy((InputStream)in, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                string = Util.toHexString(md5.digest());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("MD5 not installed", e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    @Deprecated
    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="This method should only be used for non-security applications where the MD5 weakness is not a problem.")
    private static MessageDigest getMd5() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("MD5");
    }

    @NonNull
    public static String getDigestOf(@NonNull String text) {
        try {
            return Util.getDigestOf(new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @NonNull
    public static String getDigestOf(@NonNull File file) throws IOException {
        return Util.getDigestOf(Files.newInputStream(Util.fileToPath(file), new OpenOption[0]));
    }

    @NonNull
    public static SecretKey toAes128Key(@NonNull String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.reset();
            digest.update(s.getBytes(StandardCharsets.UTF_8));
            return new SecretKeySpec(digest.digest(), 0, 16, "AES");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    @NonNull
    public static String toHexString(@NonNull byte[] data, int start, int len) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int b = data[start + i] & 0xFF;
            if (b < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(b));
        }
        return buf.toString();
    }

    @NonNull
    public static String toHexString(@NonNull byte[] bytes) {
        return Util.toHexString(bytes, 0, bytes.length);
    }

    @NonNull
    public static byte[] fromHexString(@NonNull String data) {
        if (data.length() % 2 != 0) {
            throw new IllegalArgumentException("data must have an even number of hexadecimal digits");
        }
        byte[] r = new byte[data.length() / 2];
        for (int i = 0; i < data.length(); i += 2) {
            r[i / 2] = (byte)Integer.parseInt(data.substring(i, i + 2), 16);
        }
        return r;
    }

    @NonNull
    @SuppressFBWarnings(value={"ICAST_IDIV_CAST_TO_DOUBLE"}, justification="We want to truncate here.")
    public static String getTimeSpanString(long duration) {
        long years = duration / 31536000000L;
        long months = (duration %= 31536000000L) / 2592000000L;
        long days = (duration %= 2592000000L) / 86400000L;
        long hours = (duration %= 86400000L) / 3600000L;
        long minutes = (duration %= 3600000L) / 60000L;
        long seconds = (duration %= 60000L) / 1000L;
        long millisecs = duration %= 1000L;
        if (years > 0L) {
            return Util.makeTimeSpanString(years, Messages.Util_year(years), months, Messages.Util_month(months));
        }
        if (months > 0L) {
            return Util.makeTimeSpanString(months, Messages.Util_month(months), days, Messages.Util_day(days));
        }
        if (days > 0L) {
            return Util.makeTimeSpanString(days, Messages.Util_day(days), hours, Messages.Util_hour(hours));
        }
        if (hours > 0L) {
            return Util.makeTimeSpanString(hours, Messages.Util_hour(hours), minutes, Messages.Util_minute(minutes));
        }
        if (minutes > 0L) {
            return Util.makeTimeSpanString(minutes, Messages.Util_minute(minutes), seconds, Messages.Util_second(seconds));
        }
        if (seconds >= 10L) {
            return Messages.Util_second(seconds);
        }
        if (seconds >= 1L) {
            return Messages.Util_second(Float.valueOf((float)seconds + (float)(millisecs / 100L) / 10.0f));
        }
        if (millisecs >= 100L) {
            return Messages.Util_second(Float.valueOf((float)(millisecs / 10L) / 100.0f));
        }
        return Messages.Util_millisecond(millisecs);
    }

    @NonNull
    private static String makeTimeSpanString(long bigUnit, @NonNull String bigLabel, long smallUnit, @NonNull String smallLabel) {
        Object text = bigLabel;
        if (bigUnit < 10L) {
            text = (String)text + " " + smallLabel;
        }
        return text;
    }

    @Deprecated
    @NonNull
    public static String getPastTimeString(long duration) {
        return Util.getTimeSpanString(duration);
    }

    @Deprecated
    @NonNull
    public static String combine(long n, @NonNull String suffix) {
        String s = Long.toString(n) + " " + suffix;
        if (n != 1L) {
            s = s + "s";
        }
        return s;
    }

    @NonNull
    public static <T> List<T> createSubList(@NonNull Collection<?> source, @NonNull Class<T> type) {
        ArrayList<T> r = new ArrayList<T>();
        for (Object item : source) {
            if (!type.isInstance(item)) continue;
            r.add(type.cast(item));
        }
        return r;
    }

    @NonNull
    public static String encode(@NonNull String s) {
        try {
            boolean escaped = false;
            StringBuilder out = new StringBuilder(s.length());
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)buf, StandardCharsets.UTF_8);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c < '\u0080' && c != ' ') {
                    out.append(c);
                    continue;
                }
                w.write(c);
                w.flush();
                for (byte b : buf.toByteArray()) {
                    out.append('%');
                    out.append(Util.toDigit(b >> 4 & 0xF));
                    out.append(Util.toDigit(b & 0xF));
                }
                buf.reset();
                escaped = true;
            }
            return escaped ? out.toString() : s;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @NonNull
    public static String rawEncode(@NonNull String s) {
        return Util.encode(s, uriMap);
    }

    @NonNull
    public static String fullEncode(@NonNull String s) {
        return Util.encode(s, fullUriMap);
    }

    private static String encode(String s, boolean[] map) {
        boolean escaped = false;
        StringBuilder out = null;
        CharsetEncoder enc = null;
        CharBuffer buf = null;
        int m = s.length();
        for (int i = 0; i < m; ++i) {
            Object bytes;
            int codePoint = Character.codePointAt(s, i);
            if ((codePoint & 0xFFFFFF80) == 0) {
                char c = s.charAt(i);
                if (c > 'z' || map[c]) {
                    if (!escaped) {
                        out = new StringBuilder(i + (m - i) * 3);
                        out.append(s, 0, i);
                        escaped = true;
                    }
                    if (enc == null || buf == null) {
                        enc = StandardCharsets.UTF_8.newEncoder();
                        buf = CharBuffer.allocate(1);
                    }
                    buf.put(0, c);
                    buf.rewind();
                    try {
                        bytes = enc.encode(buf);
                        while (((Buffer)bytes).hasRemaining()) {
                            byte b = ((ByteBuffer)bytes).get();
                            out.append('%');
                            out.append(Util.toDigit(b >> 4 & 0xF));
                            out.append(Util.toDigit(b & 0xF));
                        }
                        continue;
                    }
                    catch (CharacterCodingException bytes2) {
                        continue;
                    }
                }
                if (!escaped) continue;
                out.append(c);
                continue;
            }
            if (!escaped) {
                out = new StringBuilder(i + (m - i) * 3);
                out.append(s, 0, i);
                escaped = true;
            }
            bytes = new String(new int[]{codePoint}, 0, 1).getBytes(StandardCharsets.UTF_8);
            for (byte aByte : bytes) {
                out.append('%');
                out.append(Util.toDigit(aByte >> 4 & 0xF));
                out.append(Util.toDigit(aByte & 0xF));
            }
            if (Character.charCount(codePoint) <= 1) continue;
            ++i;
        }
        return escaped ? out.toString() : s;
    }

    private static char toDigit(int n) {
        return (char)(n < 10 ? 48 + n : 65 + n - 10);
    }

    public static String singleQuote(String s) {
        return "'" + s + "'";
    }

    @Nullable
    public static String escape(@CheckForNull String text) {
        if (text == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(text.length() + 64);
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                buf.append("<br>");
                continue;
            }
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            if (ch == '\"') {
                buf.append("&quot;");
                continue;
            }
            if (ch == '\'') {
                buf.append("&#039;");
                continue;
            }
            if (ch == ' ') {
                char nextCh = i + 1 < text.length() ? text.charAt(i + 1) : (char)'\u0000';
                buf.append(nextCh == ' ' ? "&nbsp;" : " ");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    @NonNull
    public static String xmlEscape(@NonNull String text) {
        StringBuilder buf = new StringBuilder(text.length() + 64);
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static void touch(@NonNull File file) throws IOException {
        Files.newOutputStream(Util.fileToPath(file), new OpenOption[0]).close();
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.335")
    public static void copyFile(@NonNull File src, @NonNull File dst) throws BuildException {
        Copy cp = new Copy();
        cp.setProject(new Project());
        cp.setTofile(dst);
        cp.setFile(src);
        cp.setOverwrite(true);
        cp.execute();
    }

    @NonNull
    public static String fixNull(@CheckForNull String s) {
        return Util.fixNull(s, "");
    }

    @NonNull
    public static <T> T fixNull(@CheckForNull T s, @NonNull T defaultValue) {
        return s != null ? s : defaultValue;
    }

    @CheckForNull
    public static String fixEmpty(@CheckForNull String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    @CheckForNull
    public static String fixEmptyAndTrim(@CheckForNull String s) {
        if (s == null) {
            return null;
        }
        return Util.fixEmpty(s.trim());
    }

    @NonNull
    public static <T> List<T> fixNull(@CheckForNull List<T> l) {
        return Util.fixNull(l, Collections.emptyList());
    }

    @NonNull
    public static <T> Set<T> fixNull(@CheckForNull Set<T> l) {
        return Util.fixNull(l, Collections.emptySet());
    }

    @NonNull
    public static <T> Collection<T> fixNull(@CheckForNull Collection<T> l) {
        return Util.fixNull(l, Collections.emptySet());
    }

    @NonNull
    public static <T> Iterable<T> fixNull(@CheckForNull Iterable<T> l) {
        return Util.fixNull(l, Collections.emptySet());
    }

    @NonNull
    public static String getFileName(@NonNull String filePath) {
        int idx = filePath.lastIndexOf(92);
        if (idx >= 0) {
            return Util.getFileName(filePath.substring(idx + 1));
        }
        idx = filePath.lastIndexOf(47);
        if (idx >= 0) {
            return Util.getFileName(filePath.substring(idx + 1));
        }
        return filePath;
    }

    @Deprecated
    @NonNull
    public static String join(@NonNull Collection<?> strings, @NonNull String separator) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Object s : strings) {
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static <T> List<T> join(Collection<? extends T> ... items) {
        void var5_8;
        int size = 0;
        for (Collection<T> collection : items) {
            size += collection.size();
        }
        ArrayList<? extends T> r = new ArrayList<T>(size);
        Collection<? extends T>[] collectionArray = items;
        int n = collectionArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            Collection<? extends T> item = collectionArray[var5_8];
            r.addAll(item);
            ++var5_8;
        }
        return r;
    }

    @NonNull
    public static FileSet createFileSet(@NonNull File baseDir, @NonNull String includes, @CheckForNull String excludes) {
        String token;
        FileSet fs = new FileSet();
        fs.setDir(baseDir);
        fs.setProject(new Project());
        StringTokenizer tokens = new StringTokenizer(includes, ",");
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken().trim();
            fs.createInclude().setName(token);
        }
        if (excludes != null) {
            tokens = new StringTokenizer(excludes, ",");
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken().trim();
                fs.createExclude().setName(token);
            }
        }
        return fs;
    }

    @NonNull
    public static FileSet createFileSet(@NonNull File baseDir, @NonNull String includes) {
        return Util.createFileSet(baseDir, includes, null);
    }

    private static void tryToDeleteSymlink(@NonNull File symlink) {
        if (!symlink.delete()) {
            LogRecord record = new LogRecord(Level.FINE, "Failed to delete temporary symlink {0}");
            record.setParameters(new Object[]{symlink.getAbsolutePath()});
            LOGGER.log(record);
        }
    }

    private static void reportAtomicFailure(@NonNull Path pathForSymlink, @NonNull Exception ex) {
        LogRecord record = new LogRecord(Level.FINE, "Failed to atomically create/replace symlink {0}");
        record.setParameters(new Object[]{pathForSymlink.toAbsolutePath().toString()});
        record.setThrown(ex);
        LOGGER.log(record);
    }

    @CheckReturnValue
    private static boolean createSymlinkAtomic(@NonNull Path pathForSymlink, @NonNull File fileForSymlink, @NonNull Path target, @NonNull String symlinkPath) {
        try {
            File symlink = File.createTempFile("symtmp", null, fileForSymlink);
            Util.tryToDeleteSymlink(symlink);
            Path tempSymlinkPath = symlink.toPath();
            Files.createSymbolicLink(tempSymlinkPath, target, new FileAttribute[0]);
            try {
                Files.move(tempSymlinkPath, pathForSymlink, StandardCopyOption.ATOMIC_MOVE);
                return true;
            }
            catch (IOException | SecurityException | UnsupportedOperationException ex) {
                Util.reportAtomicFailure(pathForSymlink, ex);
                Util.tryToDeleteSymlink(symlink);
            }
        }
        catch (IOException | SecurityException | UnsupportedOperationException | InvalidPathException ex) {
            Util.reportAtomicFailure(pathForSymlink, ex);
        }
        return false;
    }

    public static void createSymlink(@NonNull File baseDir, @NonNull String targetPath, @NonNull String symlinkPath, @NonNull TaskListener listener) throws InterruptedException {
        File fileForSymlink = new File(baseDir, symlinkPath);
        try {
            Path pathForSymlink = Util.fileToPath(fileForSymlink);
            Path target = Paths.get(targetPath, MemoryReductionUtil.EMPTY_STRING_ARRAY);
            if (Util.createSymlinkAtomic(pathForSymlink, fileForSymlink, target, symlinkPath)) {
                return;
            }
            int maxNumberOfTries = 4;
            int timeInMillis = 100;
            for (int tryNumber = 1; tryNumber <= 4; ++tryNumber) {
                Files.deleteIfExists(pathForSymlink);
                try {
                    Files.createSymbolicLink(pathForSymlink, target, new FileAttribute[0]);
                    break;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    if (tryNumber >= 4) {
                        LOGGER.log(Level.WARNING, "symlink FileAlreadyExistsException thrown {0} times => cannot createSymbolicLink", 4);
                        throw fileAlreadyExistsException;
                    }
                    TimeUnit.MILLISECONDS.sleep(100L);
                    continue;
                }
            }
        }
        catch (UnsupportedOperationException e) {
            PrintStream log = listener.getLogger();
            log.print("Symbolic links are not supported on this platform");
            Functions.printStackTrace((Throwable)e, log);
        }
        catch (IOException e) {
            if (Functions.isWindows() && e instanceof FileSystemException) {
                Util.warnWindowsSymlink();
                return;
            }
            PrintStream log = listener.getLogger();
            log.printf("ln %s %s failed%n", targetPath, fileForSymlink);
            Functions.printStackTrace((Throwable)e, log);
        }
    }

    private static void warnWindowsSymlink() {
        if (warnedSymlinks.compareAndSet(false, true)) {
            LOGGER.warning("Symbolic links enabled on this platform but disabled for this user; run as administrator or use Local Security Policy > Security Settings > Local Policies > User Rights Assignment > Create symbolic links");
        }
    }

    @Deprecated
    public static String resolveSymlink(File link, TaskListener listener) throws InterruptedException, IOException {
        return Util.resolveSymlink(link);
    }

    @CheckForNull
    public static File resolveSymlinkToFile(@NonNull File link) throws InterruptedException, IOException {
        String target = Util.resolveSymlink(link);
        if (target == null) {
            return null;
        }
        File f = new File(target);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(link.getParentFile(), target);
    }

    @CheckForNull
    public static String resolveSymlink(@NonNull File link) throws IOException {
        try {
            Path path = Util.fileToPath(link);
            return Files.readSymbolicLink(path).toString();
        }
        catch (UnsupportedOperationException | FileSystemException x) {
            return null;
        }
        catch (IOException x) {
            throw x;
        }
        catch (RuntimeException x) {
            throw new IOException(x);
        }
    }

    @Deprecated
    public static String encodeRFC2396(String url) {
        try {
            return new URI(null, url, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "Failed to encode {0}", url);
            return url;
        }
    }

    @NonNull
    public static String wrapToErrorSpan(@NonNull String s) {
        s = "<span class=error style='display:inline-block'>" + (String)s + "</span>";
        return s;
    }

    @CheckForNull
    public static Number tryParseNumber(@CheckForNull String numberStr, @CheckForNull Number defaultNumber) {
        if (numberStr == null || numberStr.length() == 0) {
            return defaultNumber;
        }
        try {
            return NumberFormat.getNumberInstance().parse(numberStr);
        }
        catch (ParseException e) {
            return defaultNumber;
        }
    }

    public static boolean isOverridden(@NonNull Class<?> base, @NonNull Class<?> derived, @NonNull String methodName, Class<?> ... types) {
        if (!base.isAssignableFrom(derived)) {
            throw new IllegalArgumentException("The specified derived class (" + derived.getCanonicalName() + ") does not derive from the specified base class (" + base.getCanonicalName() + ").");
        }
        Method baseMethod = Util.getMethod(base, null, methodName, types);
        if (baseMethod == null) {
            throw new IllegalArgumentException("The specified method is not declared by the specified base class (" + base.getCanonicalName() + "), or it is private, static or final.");
        }
        Method derivedMethod = Util.getMethod(derived, base, methodName, types);
        return derivedMethod != null && derivedMethod != baseMethod;
    }

    public static <T> T ifOverridden(Supplier<T> supplier, @NonNull Class<?> base, @NonNull Class<?> derived, @NonNull String methodName, Class<?> ... types) {
        if (Util.isOverridden(base, derived, methodName, types)) {
            return supplier.get();
        }
        throw new AbstractMethodError("The class " + derived.getName() + " must override at least one of the " + base.getSimpleName() + "." + methodName + " methods");
    }

    private static Method getMethod(@NonNull Class<?> clazz, @Nullable Class<?> base, @NonNull String methodName, Class<?> ... types) {
        try {
            Method res = clazz.getDeclaredMethod(methodName, types);
            int mod = res.getModifiers();
            if (Modifier.isPrivate(mod) || Modifier.isStatic(mod)) {
                return null;
            }
            if (base == null && Modifier.isFinal(mod)) {
                return null;
            }
            if (base != null && Modifier.isAbstract(mod)) {
                return null;
            }
            return res;
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass;
            if (base != null && Modifier.isInterface(base.getModifiers())) {
                for (Class<?> iface : clazz.getInterfaces()) {
                    Method defaultImpl;
                    if (base.equals(iface) || !base.isAssignableFrom(iface) || (defaultImpl = Util.getMethod(iface, base, methodName, types)) == null) continue;
                    return defaultImpl;
                }
            }
            if ((superclass = clazz.getSuperclass()) != null) {
                if (base != null && (base.equals(superclass) || !base.isAssignableFrom(superclass))) {
                    return null;
                }
                return Util.getMethod(superclass, base, methodName, types);
            }
            return null;
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NonNull
    public static File changeExtension(@NonNull File dst, @NonNull String ext) {
        String p = dst.getPath();
        int pos = p.lastIndexOf(46);
        if (pos < 0) {
            return new File(p + ext);
        }
        return new File(p.substring(0, pos) + ext);
    }

    @Nullable
    public static String intern(@CheckForNull String s) {
        return s == null ? s : s.intern();
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="1.651.2 / 2.3")
    public static boolean isAbsoluteUri(@NonNull String uri) {
        int idx = uri.indexOf(58);
        if (idx < 0) {
            return false;
        }
        return idx < Util._indexOf(uri, '#') && idx < Util._indexOf(uri, '?') && idx < Util._indexOf(uri, '/');
    }

    public static boolean isSafeToRedirectTo(@NonNull String uri) {
        return !Util.isAbsoluteUri(uri) && !uri.startsWith("//");
    }

    private static int _indexOf(@NonNull String s, char ch) {
        int idx = s.indexOf(ch);
        if (idx < 0) {
            return s.length();
        }
        return idx;
    }

    @NonNull
    public static Properties loadProperties(@NonNull String properties) throws IOException {
        Properties p = new Properties();
        p.load(new StringReader(properties));
        return p;
    }

    @Restricted(value={NoExternalUse.class})
    public static void closeAndLogFailures(@CheckForNull Closeable toClose, @NonNull Logger logger, @NonNull String closeableName, @NonNull String closeableOwner) {
        if (toClose == null) {
            return;
        }
        try {
            toClose.close();
        }
        catch (IOException ex) {
            LogRecord record = new LogRecord(Level.WARNING, "Failed to close {0} of {1}");
            record.setParameters(new Object[]{closeableName, closeableOwner});
            record.setThrown(ex);
            logger.log(record);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static int permissionsToMode(Set<PosixFilePermission> permissions) {
        PosixFilePermission[] allPermissions = PosixFilePermission.values();
        int result = 0;
        for (PosixFilePermission allPermission : allPermissions) {
            result <<= 1;
            result |= permissions.contains((Object)allPermission) ? 1 : 0;
        }
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    public static Set<PosixFilePermission> modeToPermissions(int mode) throws IOException {
        int PERMISSIONS_MASK = 4095;
        int MAX_SUPPORTED_MODE = 511;
        if (((mode &= PERMISSIONS_MASK) & MAX_SUPPORTED_MODE) != mode) {
            throw new IOException("Invalid mode: " + mode);
        }
        PosixFilePermission[] allPermissions = PosixFilePermission.values();
        EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
        for (int i = 0; i < allPermissions.length; ++i) {
            if ((mode & 1) == 1) {
                result.add(allPermissions[allPermissions.length - i - 1]);
            }
            mode >>= 1;
        }
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static Path fileToPath(@NonNull File file) throws IOException {
        try {
            return file.toPath();
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static Path createDirectories(@NonNull Path dir, FileAttribute<?> ... attrs) throws IOException {
        Path parent;
        dir = dir.toAbsolutePath();
        for (parent = dir.getParent(); parent != null && !Files.exists(parent, new LinkOption[0]); parent = parent.getParent()) {
        }
        if (parent == null) {
            if (Files.isDirectory(dir, new LinkOption[0])) {
                return dir;
            }
            return Files.createDirectory(dir, attrs);
        }
        Path child = parent;
        for (Path name : parent.relativize(dir)) {
            if (Files.isDirectory(child = child.resolve(name), new LinkOption[0])) continue;
            Files.createDirectory(child, attrs);
        }
        return dir;
    }

    @Restricted(value={NoExternalUse.class})
    public static long daysBetween(@NonNull Date a, @NonNull Date b) {
        LocalDate aLocal = a.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate bLocal = b.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return ChronoUnit.DAYS.between(aLocal, bLocal);
    }

    @Restricted(value={NoExternalUse.class})
    public static long daysElapsedSince(@NonNull Date date) {
        return Math.max(0L, Util.daysBetween(date, new Date()));
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static <T> T getNearestAncestorOfTypeOrThrow(@NonNull StaplerRequest request, @NonNull Class<T> clazz) {
        Object t = request.findAncestorObject(clazz);
        if (t == null) {
            throw new IllegalArgumentException("No ancestor of type " + clazz.getName() + " in the request");
        }
        return (T)t;
    }

    private static PathRemover newPathRemover(@NonNull PathRemover.PathChecker pathChecker) {
        return PathRemover.newFilteredRobustRemover(pathChecker, DELETION_RETRIES, GC_AFTER_FAILED_DELETE, WAIT_BETWEEN_DELETION_RETRIES);
    }

    static {
        int j;
        int i;
        VARIABLE = Pattern.compile("\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_.]+\\}|\\$)");
        errorCodeParser = Pattern.compile(".*CreateProcess.*error=([0-9]+).*");
        uriMap = new boolean[123];
        String raw = "!  $ &'()*+,-. 0123456789   =  @ABCDEFGHIJKLMNOPQRSTUVWXYZ    _ abcdefghijklmnopqrstuvwxyz";
        for (i = 0; i < 33; ++i) {
            Util.uriMap[i] = true;
        }
        for (j = 0; j < raw.length(); ++j) {
            Util.uriMap[i] = raw.charAt(j) == ' ';
            ++i;
        }
        fullUriMap = new boolean[123];
        raw = "               0123456789       ABCDEFGHIJKLMNOPQRSTUVWXYZ      abcdefghijklmnopqrstuvwxyz";
        for (i = 0; i < 33; ++i) {
            Util.fullUriMap[i] = true;
        }
        for (j = 0; j < raw.length(); ++j) {
            Util.fullUriMap[i] = raw.charAt(j) == ' ';
            ++i;
        }
        warnedSymlinks = new AtomicBoolean();
        XS_DATETIME_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (TimeZone)new SimpleTimeZone(0, "GMT"));
        RFC822_DATETIME_FORMATTER = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss Z", (Locale)Locale.US);
        LOGGER = Logger.getLogger(Util.class.getName());
        NO_SYMLINK = SystemProperties.getBoolean(Util.class.getName() + ".noSymLink");
        SYMLINK_ESCAPEHATCH = SystemProperties.getBoolean(Util.class.getName() + ".symlinkEscapeHatch");
        DELETION_RETRIES = Math.max(0, SystemProperties.getInteger(Util.class.getName() + ".maxFileDeletionRetries", 2));
        WAIT_BETWEEN_DELETION_RETRIES = SystemProperties.getInteger(Util.class.getName() + ".deletionRetryWait", 100);
        GC_AFTER_FAILED_DELETE = SystemProperties.getBoolean(Util.class.getName() + ".performGCOnFailedDelete");
    }
}

