/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public abstract class ComputerPinger
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(ComputerPinger.class.getName());

    public abstract boolean isReachable(InetAddress var1, int var2) throws IOException;

    public static ExtensionList<ComputerPinger> all() {
        return ExtensionList.lookup(ComputerPinger.class);
    }

    public static boolean checkIsReachable(InetAddress ia, int timeout) throws IOException {
        for (ComputerPinger pinger : ComputerPinger.all()) {
            try {
                if (!pinger.isReachable(ia, timeout)) continue;
                return true;
            }
            catch (IOException e) {
                LOGGER.fine("Error checking reachability with " + pinger + ": " + e.getMessage());
            }
        }
        return false;
    }

    @Extension
    public static class BuiltInComputerPinger
    extends ComputerPinger {
        @Override
        public boolean isReachable(InetAddress ia, int timeout) throws IOException {
            return ia.isReachable((int)TimeUnit.SECONDS.toMillis(timeout));
        }
    }
}

