/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import jenkins.model.DependencyDeclarer;
import jenkins.model.Jenkins;
import jenkins.util.DirectedGraph;

public class DependencyGraph
implements Comparator<AbstractProject> {
    private Map<AbstractProject, List<DependencyGroup>> forward = new HashMap<AbstractProject, List<DependencyGroup>>();
    private Map<AbstractProject, List<DependencyGroup>> backward = new HashMap<AbstractProject, List<DependencyGroup>>();
    private transient Map<Class<?>, Object> computationalData;
    private boolean built;
    private Comparator<AbstractProject<?, ?>> topologicalOrder;
    private List<AbstractProject<?, ?>> topologicallySorted;
    private static final Comparator<DependencyGroup> NAME_COMPARATOR = new Comparator<DependencyGroup>(){

        @Override
        public int compare(DependencyGroup lhs, DependencyGroup rhs) {
            int cmp = lhs.getUpstreamProject().getName().compareTo(rhs.getUpstreamProject().getName());
            return cmp != 0 ? cmp : lhs.getDownstreamProject().getName().compareTo(rhs.getDownstreamProject().getName());
        }
    };
    public static final DependencyGraph EMPTY = new DependencyGraph(false);

    public DependencyGraph() {
    }

    public void build() {
        try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
            this.computationalData = new HashMap();
            for (AbstractProject p : Jenkins.get().allItems(AbstractProject.class)) {
                p.buildDependencyGraph(this);
            }
            this.forward = this.finalize(this.forward);
            this.backward = this.finalize(this.backward);
            this.topologicalDagSort();
            this.computationalData = null;
            this.built = true;
        }
    }

    private void topologicalDagSort() {
        DirectedGraph<AbstractProject> g = new DirectedGraph<AbstractProject>(){

            @Override
            protected Collection<AbstractProject> nodes() {
                HashSet<AbstractProject> nodes = new HashSet<AbstractProject>();
                nodes.addAll(DependencyGraph.this.forward.keySet());
                nodes.addAll(DependencyGraph.this.backward.keySet());
                return nodes;
            }

            @Override
            protected Collection<AbstractProject> forward(AbstractProject node) {
                return DependencyGraph.this.getDownstream(node);
            }
        };
        List sccs = g.getStronglyConnectedComponents();
        HashMap<AbstractProject, Integer> topoOrder = new HashMap<AbstractProject, Integer>();
        this.topologicallySorted = new ArrayList();
        int idx = 0;
        for (DirectedGraph.SCC scc : sccs) {
            for (AbstractProject n : scc) {
                topoOrder.put(n, idx++);
                this.topologicallySorted.add(n);
            }
        }
        this.topologicalOrder = Comparator.comparingInt(topoOrder::get);
        this.topologicallySorted = Collections.unmodifiableList(this.topologicallySorted);
    }

    private DependencyGraph(boolean dummy) {
        this.backward = Collections.emptyMap();
        this.forward = this.backward;
        this.topologicalDagSort();
        this.built = true;
    }

    public <T> void putComputationalData(Class<T> key, T value) {
        this.computationalData.put(key, value);
    }

    public <T> T getComputationalData(Class<T> key) {
        Object result = this.computationalData.get(key);
        return (T)result;
    }

    public List<AbstractProject> getDownstream(AbstractProject p) {
        return this.get(this.forward, p, false);
    }

    public List<AbstractProject> getUpstream(AbstractProject p) {
        return this.get(this.backward, p, true);
    }

    private List<AbstractProject> get(Map<AbstractProject, List<DependencyGroup>> map, AbstractProject src, boolean up) {
        List<DependencyGroup> v = map.get(src);
        if (v == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractProject> result = new ArrayList<AbstractProject>(v.size());
        for (DependencyGroup d : v) {
            result.add(up ? d.getUpstreamProject() : d.getDownstreamProject());
        }
        return result;
    }

    public List<Dependency> getDownstreamDependencies(AbstractProject p) {
        return this.get(this.forward, p);
    }

    public List<Dependency> getUpstreamDependencies(AbstractProject p) {
        return this.get(this.backward, p);
    }

    private List<Dependency> get(Map<AbstractProject, List<DependencyGroup>> map, AbstractProject src) {
        List<DependencyGroup> v = map.get(src);
        if (v == null) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> builder = new ArrayList<Dependency>();
        for (DependencyGroup dependencyGroup : v) {
            builder.addAll(dependencyGroup.getGroup());
        }
        return Collections.unmodifiableList(builder);
    }

    @Deprecated
    public void addDependency(AbstractProject upstream, AbstractProject downstream) {
        this.addDependency(new Dependency(upstream, downstream));
    }

    public void addDependency(Dependency dep) {
        if (this.built) {
            throw new IllegalStateException();
        }
        this.add(this.forward, dep.getUpstreamProject(), dep);
        this.add(this.backward, dep.getDownstreamProject(), dep);
    }

    @Deprecated
    public void addDependency(AbstractProject upstream, Collection<? extends AbstractProject> downstream) {
        for (AbstractProject abstractProject : downstream) {
            this.addDependency(upstream, abstractProject);
        }
    }

    @Deprecated
    public void addDependency(Collection<? extends AbstractProject> upstream, AbstractProject downstream) {
        for (AbstractProject abstractProject : upstream) {
            this.addDependency(abstractProject, downstream);
        }
    }

    public void addDependencyDeclarers(AbstractProject upstream, Collection<?> possibleDependecyDeclarers) {
        for (Object o : possibleDependecyDeclarers) {
            if (!(o instanceof DependencyDeclarer)) continue;
            DependencyDeclarer dd = (DependencyDeclarer)o;
            dd.buildDependencyGraph(upstream, this);
        }
    }

    public boolean hasIndirectDependencies(AbstractProject src, AbstractProject dst) {
        HashSet<AbstractProject> visited = new HashSet<AbstractProject>();
        Stack<AbstractProject> queue = new Stack<AbstractProject>();
        queue.addAll(this.getDownstream(src));
        queue.remove(dst);
        while (!queue.isEmpty()) {
            AbstractProject p = (AbstractProject)queue.pop();
            if (p == dst) {
                return true;
            }
            if (!visited.add(p)) continue;
            queue.addAll(this.getDownstream(p));
        }
        return false;
    }

    public Set<AbstractProject> getTransitiveUpstream(AbstractProject src) {
        return this.getTransitive(this.backward, src, true);
    }

    public Set<AbstractProject> getTransitiveDownstream(AbstractProject src) {
        return this.getTransitive(this.forward, src, false);
    }

    private Set<AbstractProject> getTransitive(Map<AbstractProject, List<DependencyGroup>> direction, AbstractProject src, boolean up) {
        HashSet<AbstractProject> visited = new HashSet<AbstractProject>();
        Stack<AbstractProject> queue = new Stack<AbstractProject>();
        queue.add(src);
        while (!queue.isEmpty()) {
            AbstractProject p = (AbstractProject)queue.pop();
            for (AbstractProject child : this.get(direction, p, up)) {
                if (!visited.add(child)) continue;
                queue.add(child);
            }
        }
        return visited;
    }

    private void add(Map<AbstractProject, List<DependencyGroup>> map, AbstractProject key, Dependency dep) {
        List set = map.computeIfAbsent(key, k -> new ArrayList());
        for (DependencyGroup d : set) {
            if (d.getUpstreamProject() != dep.getUpstreamProject() || d.getDownstreamProject() != dep.getDownstreamProject()) continue;
            d.add(dep);
            return;
        }
        set.add(new DependencyGroup(dep));
    }

    private Map<AbstractProject, List<DependencyGroup>> finalize(Map<AbstractProject, List<DependencyGroup>> m) {
        for (Map.Entry<AbstractProject, List<DependencyGroup>> e : m.entrySet()) {
            e.getValue().sort(NAME_COMPARATOR);
            e.setValue(Collections.unmodifiableList(e.getValue()));
        }
        return Collections.unmodifiableMap(m);
    }

    @Override
    public int compare(AbstractProject o1, AbstractProject o2) {
        return this.topologicalOrder.compare(o1, o2);
    }

    public List<AbstractProject<?, ?>> getTopologicallySorted() {
        return this.topologicallySorted;
    }

    private static class DependencyGroup {
        private Set<Dependency> group = new LinkedHashSet<Dependency>();
        private AbstractProject upstream;
        private AbstractProject downstream;

        DependencyGroup(Dependency first) {
            this.upstream = first.getUpstreamProject();
            this.downstream = first.getDownstreamProject();
            this.group.add(first);
        }

        private void add(Dependency next) {
            this.group.add(next);
        }

        public Set<Dependency> getGroup() {
            return this.group;
        }

        public AbstractProject getUpstreamProject() {
            return this.upstream;
        }

        public AbstractProject getDownstreamProject() {
            return this.downstream;
        }
    }

    public static class Dependency {
        private AbstractProject upstream;
        private AbstractProject downstream;

        public Dependency(AbstractProject upstream, AbstractProject downstream) {
            this.upstream = upstream;
            this.downstream = downstream;
        }

        public AbstractProject getUpstreamProject() {
            return this.upstream;
        }

        public AbstractProject getDownstreamProject() {
            return this.downstream;
        }

        public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
            return true;
        }

        public boolean pointsItself() {
            return this.upstream == this.downstream;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Dependency that = (Dependency)obj;
            return this.upstream == that.upstream || this.downstream == that.downstream;
        }

        public int hashCode() {
            int hash = 7;
            hash = 23 * hash + this.upstream.hashCode();
            hash = 23 * hash + this.downstream.hashCode();
            return hash;
        }

        public String toString() {
            return super.toString() + "[" + this.upstream + "->" + this.downstream + "]";
        }
    }
}

