/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.util.PersistedList;
import java.io.IOException;
import javax.servlet.http.HttpSession;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.Stapler;

public class PaneStatusProperties
extends UserProperty
implements Saveable {
    private final PersistedList<String> collapsed = new PersistedList(this);
    private static final PaneStatusProperties FALLBACK = new PaneStatusPropertiesSessionFallback();

    public boolean isCollapsed(String paneId) {
        return this.collapsed.contains(paneId);
    }

    public boolean toggleCollapsed(String paneId) {
        if (this.collapsed.contains(paneId)) {
            this.collapsed.remove(paneId);
            return false;
        }
        this.collapsed.add(paneId);
        return true;
    }

    @Override
    public void save() throws IOException {
        this.user.save();
    }

    private Object readResolve() {
        this.collapsed.setOwner(this);
        return this;
    }

    public static PaneStatusProperties forCurrentUser() {
        User current = User.current();
        if (current == null) {
            return FALLBACK;
        }
        return current.getProperty(PaneStatusProperties.class);
    }

    private static class PaneStatusPropertiesSessionFallback
    extends PaneStatusProperties {
        private static final String attribute = "jenkins_pane_%s_collapsed";

        private PaneStatusPropertiesSessionFallback() {
        }

        @Override
        public boolean isCollapsed(String paneId) {
            HttpSession session = Stapler.getCurrentRequest().getSession();
            return session.getAttribute(String.format(attribute, paneId)) != null;
        }

        @Override
        public boolean toggleCollapsed(String paneId) {
            HttpSession session = Stapler.getCurrentRequest().getSession();
            String property = String.format(attribute, paneId);
            Object collapsed = session.getAttribute(property);
            if (collapsed == null) {
                session.setAttribute(property, (Object)true);
                return true;
            }
            session.removeAttribute(property);
            return false;
        }
    }

    @Extension
    @Symbol(value={"paneStatus"})
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        @Override
        public UserProperty newInstance(User user) {
            return new PaneStatusProperties();
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }
}

