/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.Result;
import hudson.model.Run;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.model.PeepholePermalink;

public interface PermalinkProjectAction
extends Action {
    public List<Permalink> getPermalinks();

    public static abstract class Permalink {
        public static final List<Permalink> BUILTIN = new CopyOnWriteArrayList<Permalink>();
        public static final Permalink LAST_BUILD = new Permalink(){

            @Override
            public String getDisplayName() {
                return Messages.Permalink_LastBuild();
            }

            @Override
            public String getId() {
                return "lastBuild";
            }

            @Override
            public Run<?, ?> resolve(Job<?, ?> job) {
                return job.getLastBuild();
            }
        };
        public static final Permalink LAST_STABLE_BUILD = new PeepholePermalink(){

            @Override
            public String getDisplayName() {
                return Messages.Permalink_LastStableBuild();
            }

            @Override
            public String getId() {
                return "lastStableBuild";
            }

            @Override
            public boolean apply(Run<?, ?> run) {
                return !run.isBuilding() && run.getResult() == Result.SUCCESS;
            }
        };
        public static final Permalink LAST_SUCCESSFUL_BUILD = new PeepholePermalink(){

            @Override
            public String getDisplayName() {
                return Messages.Permalink_LastSuccessfulBuild();
            }

            @Override
            public String getId() {
                return "lastSuccessfulBuild";
            }

            @Override
            @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
            public boolean apply(Run<?, ?> run) {
                return !run.isBuilding() && run.getResult().isBetterOrEqualTo(Result.UNSTABLE);
            }
        };
        public static final Permalink LAST_FAILED_BUILD = new PeepholePermalink(){

            @Override
            public String getDisplayName() {
                return Messages.Permalink_LastFailedBuild();
            }

            @Override
            public String getId() {
                return "lastFailedBuild";
            }

            @Override
            public boolean apply(Run<?, ?> run) {
                return !run.isBuilding() && run.getResult() == Result.FAILURE;
            }
        };
        public static final Permalink LAST_UNSTABLE_BUILD = new PeepholePermalink(){

            @Override
            public String getDisplayName() {
                return Messages.Permalink_LastUnstableBuild();
            }

            @Override
            public String getId() {
                return "lastUnstableBuild";
            }

            @Override
            public boolean apply(Run<?, ?> run) {
                return !run.isBuilding() && run.getResult() == Result.UNSTABLE;
            }
        };
        public static final Permalink LAST_UNSUCCESSFUL_BUILD = new PeepholePermalink(){

            @Override
            public String getDisplayName() {
                return Messages.Permalink_LastUnsuccessfulBuild();
            }

            @Override
            public String getId() {
                return "lastUnsuccessfulBuild";
            }

            @Override
            public boolean apply(Run<?, ?> run) {
                return !run.isBuilding() && run.getResult() != Result.SUCCESS;
            }
        };
        public static final Permalink LAST_COMPLETED_BUILD = new PeepholePermalink(){

            @Override
            public String getDisplayName() {
                return Messages.Permalink_LastCompletedBuild();
            }

            @Override
            public String getId() {
                return "lastCompletedBuild";
            }

            @Override
            public boolean apply(Run<?, ?> run) {
                return !run.isBuilding();
            }
        };

        public abstract String getDisplayName();

        public abstract String getId();

        @CheckForNull
        public abstract Run<?, ?> resolve(Job<?, ?> var1);

        static {
            BUILTIN.add(LAST_BUILD);
            BUILTIN.add(LAST_STABLE_BUILD);
            BUILTIN.add(LAST_SUCCESSFUL_BUILD);
            BUILTIN.add(LAST_FAILED_BUILD);
            BUILTIN.add(LAST_UNSTABLE_BUILD);
            BUILTIN.add(LAST_UNSUCCESSFUL_BUILD);
            BUILTIN.add(LAST_COMPLETED_BUILD);
        }
    }
}

