/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.RunMap;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class ViewJob<JobT extends ViewJob<JobT, RunT>, RunT extends Run<JobT, RunT>>
extends Job<JobT, RunT> {
    private static final Logger LOGGER = Logger.getLogger(ViewJob.class.getName());
    private transient long nextUpdate = 0L;
    protected volatile transient RunMap<RunT> runs = new RunMap(null, null);
    private volatile transient boolean notLoaded = true;
    private volatile transient boolean reloadingInProgress;
    private static ReloadThread reloadThread;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean reloadPeriodically;

    static synchronized void interruptReloadThread() {
        if (reloadThread != null) {
            reloadThread.interrupt();
        }
    }

    @Deprecated
    protected ViewJob(Jenkins parent, String name) {
        super(parent, name);
    }

    protected ViewJob(ItemGroup parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean isBuildable() {
        return false;
    }

    @Override
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.notLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SortedMap<Integer, RunT> _getRuns() {
        if (this.notLoaded || this.runs == null) {
            ViewJob viewJob = this;
            synchronized (viewJob) {
                if (this.runs == null) {
                    this.runs = new RunMap();
                }
                if (this.notLoaded) {
                    this.notLoaded = false;
                    this._reload();
                }
            }
        }
        if (this.nextUpdate >= System.currentTimeMillis() || this.reloadingInProgress) return this.runs;
        this.reloadingInProgress = true;
        Object object = ViewJob.class;
        synchronized (ViewJob.class) {
            if (reloadThread == null) {
                reloadThread = new ReloadThread();
                reloadThread.start();
            }
            Set<ViewJob> reloadQueue = ViewJob.reloadThread.reloadQueue;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            object = reloadQueue;
            synchronized (object) {
                reloadQueue.add(this);
                reloadQueue.notify();
                return this.runs;
            }
        }
    }

    @Override
    public void removeRun(RunT run) {
        if (this.runs != null && !this.runs.remove(run)) {
            LOGGER.log(Level.WARNING, "{0} did not contain {1} to begin with", new Object[]{this, run});
        }
    }

    private void _reload() {
        long l;
        try {
            this.reload();
            this.reloadingInProgress = false;
            l = reloadPeriodically ? System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L) : Long.MAX_VALUE;
        }
        catch (Throwable throwable) {
            this.reloadingInProgress = false;
            this.nextUpdate = reloadPeriodically ? System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L) : Long.MAX_VALUE;
            throw throwable;
        }
        this.nextUpdate = l;
    }

    protected abstract void reload();

    @Override
    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        this.nextUpdate = 0L;
    }

    static {
        reloadPeriodically = SystemProperties.getBoolean(ViewJob.class.getName() + ".reloadPeriodically");
    }

    private static final class ReloadThread
    extends Thread {
        final Set<ViewJob> reloadQueue = new LinkedHashSet<ViewJob>();

        private ReloadThread() {
            this.setName("ViewJob reload thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ViewJob getNext() throws InterruptedException {
            Set<ViewJob> set = this.reloadQueue;
            synchronized (set) {
                while (this.reloadQueue.isEmpty() && !this.terminating()) {
                    this.reloadQueue.wait(TimeUnit.MINUTES.toMillis(1L));
                }
                if (this.terminating()) {
                    throw new InterruptedException();
                }
                ViewJob job = this.reloadQueue.iterator().next();
                this.reloadQueue.remove(job);
                return job;
            }
        }

        private boolean terminating() {
            return Jenkins.get().isTerminating();
        }

        @Override
        public void run() {
            while (!this.terminating()) {
                try {
                    this.getNext()._reload();
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

