/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.security.BasicAuthenticationFilter;
import hudson.security.ChainedServletFilter;
import hudson.security.ContainerAuthentication;
import hudson.security.Messages;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public final class LegacySecurityRealm
extends SecurityRealm
implements AuthenticationManager {
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static Descriptor<SecurityRealm> DESCRIPTOR;

    @DataBoundConstructor
    public LegacySecurityRealm() {
    }

    @Override
    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(this);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication instanceof ContainerAuthentication) {
            return authentication;
        }
        return null;
    }

    @Override
    public String getAuthenticationGatewayUrl() {
        return "j_security_check";
    }

    @Override
    public String getLoginUrl() {
        return "loginEntry";
    }

    @Override
    public Filter createFilter(FilterConfig filterConfig) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new BasicAuthenticationFilter());
        filters.addAll(this.commonFilters());
        return new ChainedServletFilter(filters);
    }

    @Extension
    @Symbol(value={"legacy"})
    public static class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="for backward compatibility")
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.LegacySecurityRealm_Displayname();
        }
    }
}

