/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Slave;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class AbstractCloudComputer<T extends AbstractCloudSlave>
extends SlaveComputer {
    public AbstractCloudComputer(T slave) {
        super((Slave)slave);
    }

    @CheckForNull
    public T getNode() {
        return (T)((AbstractCloudSlave)super.getNode());
    }

    @Override
    @RequirePOST
    public HttpResponse doDoDelete() throws IOException {
        this.checkPermission(DELETE);
        try {
            Slave node = this.getNode();
            if (node != null) {
                ((AbstractCloudSlave)node).terminate();
            }
            return new HttpRedirect("..");
        }
        catch (InterruptedException e) {
            return HttpResponses.error((int)500, (Throwable)e);
        }
    }
}

