/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import net.jcip.annotations.GuardedBy;

public class CloudSlaveRetentionStrategy<T extends Computer>
extends RetentionStrategy<T> {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static long TIMEOUT = SystemProperties.getLong(CloudSlaveRetentionStrategy.class.getName() + ".timeout", TimeUnit.MINUTES.toMillis(10L));
    private static final Logger LOGGER = Logger.getLogger(CloudSlaveRetentionStrategy.class.getName());

    @Override
    @GuardedBy(value="hudson.model.Queue.lock")
    public long check(T c) {
        if (!((Computer)c).isConnecting() && ((Computer)c).isAcceptingTasks() && this.isIdleForTooLong(c)) {
            try {
                Node n = ((Computer)c).getNode();
                if (n != null) {
                    this.kill(n);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to remove " + ((Computer)c).getDisplayName(), e);
            }
        }
        return this.checkCycle();
    }

    protected void kill(Node n) throws IOException {
        Jenkins.get().removeNode(n);
    }

    protected long checkCycle() {
        return this.getIdleMaxTime() / 10L;
    }

    protected boolean isIdleForTooLong(T c) {
        return System.currentTimeMillis() - ((Computer)c).getIdleStartMilliseconds() > this.getIdleMaxTime();
    }

    protected long getIdleMaxTime() {
        return TIMEOUT;
    }
}

