/*
 * Decompiled with CFR 0.152.
 */
package jenkins.install;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.UpdateCenter;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.install.InstallUtil;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.security.apitoken.ApiTokenPropertyConfiguration;
import jenkins.security.stapler.StaplerAccessibleType;
import jenkins.util.Timer;
import org.apache.commons.lang.StringUtils;

@StaplerAccessibleType
public class InstallState
implements ExtensionPoint {
    @Deprecated
    private static final InstallState[] UNUSED_INNER_CLASSES = new InstallState[]{new InstallState("UNKNOWN", false){}, new InstallState("INITIAL_SETUP_COMPLETED", false){}, new InstallState("CREATE_ADMIN_USER", false){}, new InstallState("INITIAL_SECURITY_SETUP", false){}, new InstallState("RESTART", false){}, new InstallState("DOWNGRADE", false){}};
    @Extension
    public static final InstallState UNKNOWN = new Unknown();
    @Extension
    public static final InstallState RUNNING = new InstallState("RUNNING", true);
    @Extension
    public static final InstallState INITIAL_SETUP_COMPLETED = new InitialSetupCompleted();
    @Extension
    public static final InstallState CREATE_ADMIN_USER = new CreateAdminUser();
    @Extension
    public static final InstallState CONFIGURE_INSTANCE = new ConfigureInstance();
    @Extension
    public static final InstallState INITIAL_PLUGINS_INSTALLING = new InstallState("INITIAL_PLUGINS_INSTALLING", false);
    @Extension
    public static final InstallState INITIAL_SECURITY_SETUP = new InitialSecuritySetup();
    @Extension
    public static final InstallState NEW = new InstallState("NEW", false);
    @Extension
    public static final InstallState RESTART = new Restart();
    @Extension
    public static final InstallState UPGRADE = new Upgrade();
    @Extension
    public static final InstallState DOWNGRADE = new Downgrade();
    private static final Logger LOGGER = Logger.getLogger(InstallState.class.getName());
    public static final InstallState TEST = new InstallState("TEST", true);
    public static final InstallState DEVELOPMENT = new InstallState("DEVELOPMENT", true);
    private final transient boolean isSetupComplete;
    private final String name;

    private static void reloadUpdateSiteData() {
        Timer.get().submit(UpdateCenter::updateAllSitesNow);
    }

    public InstallState(@NonNull String name, boolean isSetupComplete) {
        this.name = name;
        this.isSetupComplete = isSetupComplete;
    }

    public void initializeState() {
    }

    @Deprecated
    protected Object readResolve() {
        if (StringUtils.isBlank((String)this.name)) {
            LOGGER.log(Level.WARNING, "Read install state with blank name: ''{0}''. It will be ignored", this.name);
            return UNKNOWN;
        }
        InstallState state = InstallState.valueOf(this.name);
        if (state == null) {
            LOGGER.log(Level.WARNING, "Cannot locate an extension point for the state ''{0}''. It will be ignored", this.name);
            return UNKNOWN;
        }
        return state;
    }

    public boolean isSetupComplete() {
        return this.isSetupComplete;
    }

    public String name() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof InstallState) {
            return this.name.equals(((InstallState)obj).name());
        }
        return false;
    }

    public String toString() {
        return "InstallState (" + this.name + ")";
    }

    @CheckForNull
    public static InstallState valueOf(@NonNull String name) {
        for (InstallState state : InstallState.all()) {
            if (!name.equals(state.name)) continue;
            return state;
        }
        return null;
    }

    static ExtensionList<InstallState> all() {
        return ExtensionList.lookup(InstallState.class);
    }

    private static final class Downgrade
    extends InstallState {
        Downgrade() {
            super("DOWNGRADE", true);
        }

        @Override
        public void initializeState() {
            InstallState.reloadUpdateSiteData();
            InstallUtil.saveLastExecVersion();
        }
    }

    private static final class Upgrade
    extends InstallState {
        Upgrade() {
            super("UPGRADE", true);
        }

        @Override
        public void initializeState() {
            this.applyForcedChanges();
            InstallState.reloadUpdateSiteData();
            InstallUtil.saveLastExecVersion();
        }

        private void applyForcedChanges() {
            ApiTokenPropertyConfiguration apiTokenPropertyConfiguration = ApiTokenPropertyConfiguration.get();
            if (!apiTokenPropertyConfiguration.hasExistingConfigFile()) {
                LOGGER.log(Level.INFO, "New API token system configured with insecure options to keep legacy behavior");
                apiTokenPropertyConfiguration.setCreationOfLegacyTokenEnabled(false);
                apiTokenPropertyConfiguration.setTokenGenerationOnCreationEnabled(false);
            }
        }
    }

    private static final class Restart
    extends InstallState {
        Restart() {
            super("RESTART", true);
        }

        @Override
        public void initializeState() {
            InstallUtil.saveLastExecVersion();
        }
    }

    private static final class InitialSecuritySetup
    extends InstallState {
        InitialSecuritySetup() {
            super("INITIAL_SECURITY_SETUP", false);
        }

        @Override
        public void initializeState() {
            try {
                Jenkins.get().getSetupWizard().init(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            InstallUtil.proceedToNextStateFrom(INITIAL_SECURITY_SETUP);
        }
    }

    private static final class ConfigureInstance
    extends InstallState {
        ConfigureInstance() {
            super("CONFIGURE_INSTANCE", false);
        }

        @Override
        public void initializeState() {
            if (StringUtils.isNotBlank((String)JenkinsLocationConfiguration.getOrDie().getUrl())) {
                InstallUtil.proceedToNextStateFrom(this);
            }
        }
    }

    private static final class CreateAdminUser
    extends InstallState {
        CreateAdminUser() {
            super("CREATE_ADMIN_USER", false);
        }

        @Override
        public void initializeState() {
            Jenkins j = Jenkins.get();
            if (!j.getSetupWizard().isUsingSecurityDefaults()) {
                InstallUtil.proceedToNextStateFrom(this);
            }
        }
    }

    private static final class InitialSetupCompleted
    extends InstallState {
        InitialSetupCompleted() {
            super("INITIAL_SETUP_COMPLETED", true);
        }

        @Override
        public void initializeState() {
            Jenkins j = Jenkins.get();
            try {
                j.getSetupWizard().completeSetup();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            j.setInstallState(RUNNING);
        }
    }

    private static class Unknown
    extends InstallState {
        Unknown() {
            super("UNKNOWN", true);
        }

        @Override
        public void initializeState() {
            InstallUtil.proceedToNextStateFrom(this);
        }
    }
}

