/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.model.Descriptor;
import hudson.model.RootAction;
import hudson.slaves.Cloud;
import hudson.util.FormApply;
import java.io.IOException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.Messages;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"cloud"})
@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="2.205")
public class GlobalCloudConfiguration
implements RootAction {
    @Override
    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @Override
    @CheckForNull
    public String getDisplayName() {
        return Messages.GlobalCloudConfiguration_DisplayName();
    }

    @Override
    public String getUrlName() {
        return "configureClouds";
    }

    @POST
    public void doConfigure(StaplerRequest req, StaplerResponse rsp) throws Descriptor.FormException, IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JSONObject json = req.getSubmittedForm();
        Jenkins.get().clouds.rebuildHetero(req, json, Cloud.all(), "cloud");
        FormApply.success(req.getContextPath() + "/manage").generateResponse(req, rsp, null);
    }
}

