/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import com.google.common.primitives.Ints;
import hudson.Functions;
import hudson.util.ProcessTree;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class JavaVMArguments {
    public static List<String> current() {
        ProcessHandle.Info info = ProcessHandle.current().info();
        if (info.command().isPresent() && info.arguments().isPresent()) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(info.command().get());
            Stream.of(info.arguments().get()).forEach(args::add);
            return args;
        }
        if (Functions.isGlibcSupported()) {
            List<String> args;
            int pid = Ints.checkedCast((long)ProcessHandle.current().pid());
            ProcessTree.OSProcess process = ProcessTree.get().get(pid);
            if (process != null && !(args = process.getArguments()).isEmpty()) {
                return args;
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(Paths.get(System.getProperty("java.home"), new String[0]).resolve("bin").resolve("java").toString());
        args.addAll(ManagementFactory.getRuntimeMXBean().getInputArguments());
        return args;
    }
}

