/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.AttributeNameIterator;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.AbstractXmlReader;
import com.thoughtworks.xstream.io.xml.AbstractXmlWriter;
import com.thoughtworks.xstream.io.xml.DocumentReader;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.util.VariableResolver;
import hudson.util.XStream2;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class XStreamDOM {
    private final String tagName;
    private final String[] attributes;
    private final String value;
    private final List<XStreamDOM> children;
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.301")
    public static final XmlFriendlyReplacer REPLACER = new XmlFriendlyReplacer();

    public XStreamDOM(String tagName, Map<String, String> attributes, String value) {
        this.tagName = tagName;
        this.attributes = this.toAttributeList(attributes);
        this.value = value;
        this.children = null;
    }

    public XStreamDOM(String tagName, Map<String, String> attributes, List<XStreamDOM> children) {
        this.tagName = tagName;
        this.attributes = this.toAttributeList(attributes);
        this.value = null;
        this.children = children;
    }

    private XStreamDOM(String tagName, String[] attributes, List<XStreamDOM> children, String value) {
        this.tagName = tagName;
        this.attributes = attributes;
        this.children = children;
        this.value = value;
    }

    private String[] toAttributeList(Map<String, String> attributes) {
        String[] r = new String[attributes.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            r[i++] = e.getKey();
            r[i++] = e.getValue();
        }
        return r;
    }

    public String getTagName() {
        return this.tagName;
    }

    public <T> T unmarshal(XStream xs) {
        return (T)xs.unmarshal(this.newReader());
    }

    public <T> T unmarshal(XStream xs, T root) {
        return (T)xs.unmarshal(this.newReader(), root);
    }

    public XStreamDOM expandMacro(VariableResolver<String> vars) {
        String[] newAttributes = new String[this.attributes.length];
        for (int i = 0; i < this.attributes.length; i += 2) {
            newAttributes[i + 0] = this.attributes[i];
            newAttributes[i + 1] = Util.replaceMacro(this.attributes[i + 1], vars);
        }
        ArrayList<XStreamDOM> newChildren = null;
        if (this.children != null) {
            newChildren = new ArrayList<XStreamDOM>(this.children.size());
            for (XStreamDOM d : this.children) {
                newChildren.add(d.expandMacro(vars));
            }
        }
        return new XStreamDOM(this.tagName, newAttributes, newChildren, Util.replaceMacro(this.value, vars));
    }

    public String getAttribute(String name) {
        for (int i = 0; i < this.attributes.length; i += 2) {
            if (!this.attributes[i].equals(name)) continue;
            return this.attributes[i + 1];
        }
        return null;
    }

    public int getAttributeCount() {
        return this.attributes.length / 2;
    }

    String getAttributeName(int index) {
        return this.attributes[index * 2];
    }

    public String getAttribute(int index) {
        return this.attributes[index * 2 + 1];
    }

    public String getValue() {
        return this.value;
    }

    public List<XStreamDOM> getChildren() {
        return this.children;
    }

    public HierarchicalStreamReader newReader() {
        return new ReaderImpl(this);
    }

    public static WriterImpl newWriter() {
        return new WriterImpl();
    }

    public void writeTo(OutputStream os) {
        this.writeTo(XStream2.getDefaultDriver().createWriter(os));
    }

    public void writeTo(Writer w) {
        this.writeTo(XStream2.getDefaultDriver().createWriter(w));
    }

    public void writeTo(HierarchicalStreamWriter w) {
        new ConverterImpl().marshal(this, w, null);
    }

    public static XStreamDOM from(XStream xs, Object obj) {
        WriterImpl w = XStreamDOM.newWriter();
        xs.marshal(obj, (HierarchicalStreamWriter)w);
        return w.getOutput();
    }

    public static XStreamDOM from(InputStream in) {
        return XStreamDOM.from(XStream2.getDefaultDriver().createReader(in));
    }

    public static XStreamDOM from(Reader in) {
        return XStreamDOM.from(XStream2.getDefaultDriver().createReader(in));
    }

    public static XStreamDOM from(HierarchicalStreamReader in) {
        return new ConverterImpl().unmarshalElement(in, null);
    }

    public Map<String, String> getAttributeMap() {
        HashMap<String, String> r = new HashMap<String, String>();
        for (int i = 0; i < this.attributes.length; i += 2) {
            r.put(this.attributes[i], this.attributes[i + 1]);
        }
        return r;
    }

    public static class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == XStreamDOM.class;
        }

        private String unescape(String s) {
            return REPLACER.unescapeName(s);
        }

        private String escape(String s) {
            return REPLACER.escapeName(s);
        }

        public void marshal(Object source, HierarchicalStreamWriter w, MarshallingContext context) {
            XStreamDOM dom = (XStreamDOM)source;
            w.startNode(this.unescape(dom.tagName));
            for (int i = 0; i < dom.attributes.length; i += 2) {
                w.addAttribute(this.unescape(dom.attributes[i]), dom.attributes[i + 1]);
            }
            if (dom.value != null) {
                w.setValue(dom.value);
            } else {
                for (XStreamDOM c : Util.fixNull(dom.children)) {
                    this.marshal(c, w, context);
                }
            }
            w.endNode();
        }

        public XStreamDOM unmarshal(HierarchicalStreamReader r, UnmarshallingContext context) {
            r.moveDown();
            XStreamDOM dom = this.unmarshalElement(r, context);
            r.moveUp();
            return dom;
        }

        public XStreamDOM unmarshalElement(HierarchicalStreamReader r, UnmarshallingContext context) {
            String name = this.escape(r.getNodeName());
            int c = r.getAttributeCount();
            String[] attributes = new String[c * 2];
            for (int i = 0; i < c; ++i) {
                attributes[i * 2] = this.escape(r.getAttributeName(i));
                attributes[i * 2 + 1] = r.getAttribute(i);
            }
            ArrayList<XStreamDOM> children = null;
            String value = null;
            if (r.hasMoreChildren()) {
                children = new ArrayList<XStreamDOM>();
                while (r.hasMoreChildren()) {
                    children.add(this.unmarshal(r, context));
                }
            } else {
                value = r.getValue();
            }
            return new XStreamDOM(name, attributes, children, value);
        }
    }

    public static class WriterImpl
    extends AbstractXmlWriter {
        private final Stack<Pending> pendings = new Stack();

        public WriterImpl() {
            this.pendings.push(new Pending(null));
        }

        public void startNode(String name) {
            this.pendings.push(new Pending(this.escapeXmlName(name)));
        }

        public void endNode() {
            XStreamDOM dom = this.pendings.pop().toDOM();
            this.pendings.peek().addChild(dom);
        }

        public void addAttribute(String name, String value) {
            List<String> atts = this.pendings.peek().attributes;
            atts.add(this.escapeXmlName(name));
            atts.add(value);
        }

        public void setValue(String text) {
            this.pendings.peek().value = text;
        }

        public void flush() {
        }

        public void close() {
        }

        public HierarchicalStreamWriter underlyingWriter() {
            return this;
        }

        public XStreamDOM getOutput() {
            if (this.pendings.size() != 1) {
                throw new IllegalStateException();
            }
            return this.pendings.peek().children.get(0);
        }

        private static class Pending {
            final String tagName;
            List<XStreamDOM> children;
            List<String> attributes = new ArrayList<String>();
            String value;

            private Pending(String tagName) {
                this.tagName = tagName;
            }

            void addChild(XStreamDOM dom) {
                if (this.children == null) {
                    this.children = new ArrayList<XStreamDOM>();
                }
                this.children.add(dom);
            }

            XStreamDOM toDOM() {
                return new XStreamDOM(this.tagName, this.attributes.toArray(new String[this.attributes.size()]), this.children, this.value);
            }
        }
    }

    private static class ReaderImpl
    extends AbstractXmlReader
    implements DocumentReader {
        private final Stack<Pointer> pointers = new Stack();

        ReaderImpl(XStreamDOM current) {
            super(new XmlFriendlyReplacer());
            this.pointers.push(new Pointer(current));
        }

        private Pointer current() {
            return this.pointers.peek();
        }

        public Object getCurrent() {
            return this.current().node;
        }

        public boolean hasMoreChildren() {
            return this.current().hasMoreChildren();
        }

        public HierarchicalStreamReader underlyingReader() {
            return this;
        }

        public void moveDown() {
            Pointer p = this.current();
            this.pointers.push(new Pointer(p.node.children.get(p.pos++)));
        }

        public void moveUp() {
            this.pointers.pop();
        }

        public Iterator getAttributeNames() {
            return new AttributeNameIterator((HierarchicalStreamReader)this);
        }

        public void appendErrors(ErrorWriter errorWriter) {
            StringBuilder buf = new StringBuilder();
            Pointer parent = null;
            for (Pointer cur : this.pointers) {
                if (parent != null) {
                    buf.append('/').append(parent.xpath());
                } else {
                    buf.append(cur.node.tagName);
                }
                parent = cur;
            }
            errorWriter.add("xpath", buf.toString());
        }

        public void close() {
        }

        public String peekNextChild() {
            return this.current().peekNextChild();
        }

        public String getNodeName() {
            return this.unescapeXmlName(this.current().node.tagName);
        }

        public String getValue() {
            return Util.fixNull(this.current().node.value);
        }

        public String getAttribute(String name) {
            return this.current().node.getAttribute(name);
        }

        public String getAttribute(int index) {
            return this.current().node.getAttribute(index);
        }

        public int getAttributeCount() {
            return this.current().node.getAttributeCount();
        }

        public String getAttributeName(int index) {
            return this.unescapeXmlName(this.current().node.getAttributeName(index));
        }

        private static class Pointer {
            final XStreamDOM node;
            int pos;

            private Pointer(XStreamDOM node) {
                this.node = node;
            }

            public String peekNextChild() {
                if (this.hasMoreChildren()) {
                    return this.node.children.get((int)this.pos).tagName;
                }
                return null;
            }

            public boolean hasMoreChildren() {
                return this.node.children != null && this.pos < this.node.children.size();
            }

            public String xpath() {
                XStreamDOM child = this.node.children.get(this.pos - 1);
                int count = 0;
                for (int i = 0; i < this.pos - 1; ++i) {
                    if (!this.node.children.get((int)i).tagName.equals(child.tagName)) continue;
                    ++count;
                }
                boolean more = false;
                for (int i = this.pos; i < this.node.children.size(); ++i) {
                    if (!this.node.children.get((int)i).tagName.equals(child.tagName)) continue;
                    more = true;
                    break;
                }
                if (count == 0 && !more) {
                    return child.tagName;
                }
                return child.tagName + "[" + count + "]";
            }
        }
    }
}

