/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.Messages;
import hudson.cli.RunRangeCommand;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import hudson.util.QuotedStringTokenizer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import jenkins.scm.RunWithSCM;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Option;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;

@Restricted(value={NoExternalUse.class})
@Extension
public class ListChangesCommand
extends RunRangeCommand {
    @Option(name="-format", usage="Controls how the output from this command is printed.")
    public Format format = Format.PLAIN;

    @Override
    public String getShortDescription() {
        return Messages.ListChangesCommand_ShortDescription();
    }

    @Override
    protected int act(List<Run<?, ?>> builds) throws IOException {
        switch (this.format) {
            case XML: {
                Charset charset;
                try {
                    charset = this.getClientCharset();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)this.stdout, charset));
                w.println("<changes>");
                for (Run<?, ?> build : builds) {
                    if (!(build instanceof RunWithSCM)) continue;
                    w.println("<build number='" + build.getNumber() + "'>");
                    for (ChangeLogSet<ChangeLogSet.Entry> cs : ((RunWithSCM)((Object)build)).getChangeSets()) {
                        Model p = new ModelBuilder().get(cs.getClass());
                        p.writeTo(cs, Flavor.XML.createDataWriter(cs, (Writer)w));
                    }
                    w.println("</build>");
                }
                w.println("</changes>");
                w.flush();
                break;
            }
            case CSV: {
                for (Run<?, ?> build : builds) {
                    if (!(build instanceof RunWithSCM)) continue;
                    for (ChangeLogSet<ChangeLogSet.Entry> cs : ((RunWithSCM)((Object)build)).getChangeSets()) {
                        for (ChangeLogSet.Entry e : cs) {
                            this.stdout.printf("%s,%s%n", QuotedStringTokenizer.quote((String)e.getAuthor().getId()), QuotedStringTokenizer.quote((String)e.getMsg()));
                        }
                    }
                }
                break;
            }
            case PLAIN: {
                for (Run<?, ?> build : builds) {
                    if (!(build instanceof RunWithSCM)) continue;
                    for (ChangeLogSet<ChangeLogSet.Entry> cs : ((RunWithSCM)((Object)build)).getChangeSets()) {
                        for (ChangeLogSet.Entry e : cs) {
                            this.stdout.printf("%s\t%s%n", e.getAuthor(), e.getMsg());
                            for (String p : e.getAffectedPaths()) {
                                this.stdout.println("  " + p);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown format: " + this.format));
            }
        }
        return 0;
    }

    static enum Format {
        XML,
        CSV,
        PLAIN;

    }
}

