/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli.declarative;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionComponent;
import hudson.ExtensionFinder;
import hudson.Functions;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.cli.CloneableCLICommand;
import hudson.cli.declarative.CLIMethod;
import hudson.cli.declarative.CLIResolver;
import hudson.cli.declarative.MethodBinder;
import hudson.model.Hudson;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Stack;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.ExtensionComponentSet;
import jenkins.ExtensionRefreshException;
import jenkins.model.Jenkins;
import org.jvnet.hudson.annotation_indexer.Index;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@Extension
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION", "THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"}, justification="TODO needs triage")
public class CLIRegisterer
extends ExtensionFinder {
    private static final Logger LOGGER = Logger.getLogger(CLIRegisterer.class.getName());

    @Override
    public ExtensionComponentSet refresh() throws ExtensionRefreshException {
        return ExtensionComponentSet.EMPTY;
    }

    @Override
    public <T> Collection<ExtensionComponent<T>> find(Class<T> type, Hudson jenkins) {
        if (type == CLICommand.class) {
            return this.discover(jenkins);
        }
        return Collections.emptyList();
    }

    private Method findResolver(Class type) throws IOException {
        List<Method> resolvers = Util.filter(Index.list(CLIResolver.class, (ClassLoader)Jenkins.get().getPluginManager().uberClassLoader), Method.class);
        while (type != null) {
            for (Method m : resolvers) {
                if (m.getReturnType() != type) continue;
                return m;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    private List<ExtensionComponent<CLICommand>> discover(final @NonNull Jenkins jenkins) {
        LOGGER.fine("Listing up @CLIMethod");
        ArrayList<ExtensionComponent<CLICommand>> r = new ArrayList<ExtensionComponent<CLICommand>>();
        try {
            for (final Method m : Util.filter(Index.list(CLIMethod.class, (ClassLoader)jenkins.getPluginManager().uberClassLoader), Method.class)) {
                try {
                    final String name = m.getAnnotation(CLIMethod.class).name();
                    final ResourceBundleHolder res = this.loadMessageBundle(m);
                    res.format("CLI." + name + ".shortDescription", new Object[0]);
                    r.add(new ExtensionComponent<1>(new CloneableCLICommand(){

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public String getShortDescription() {
                            return res.format("CLI." + name + ".shortDescription", new Object[0]);
                        }

                        @Override
                        protected CmdLineParser getCmdLineParser() {
                            return this.bindMethod(new ArrayList<MethodBinder>());
                        }

                        private CmdLineParser bindMethod(List<MethodBinder> binders) {
                            Stack<Method> chains;
                            CmdLineParser parser;
                            block4: {
                                Class<?> type;
                                this.registerOptionHandlers();
                                parser = new CmdLineParser(null);
                                chains = new Stack<Method>();
                                Method method = m;
                                do {
                                    chains.push(method);
                                    if (Modifier.isStatic(method.getModifiers())) break block4;
                                    type = method.getDeclaringClass();
                                    try {
                                        method = CLIRegisterer.this.findResolver(type);
                                    }
                                    catch (IOException ex) {
                                        throw new RuntimeException("Unable to find the resolver method annotated with @CLIResolver for " + type, ex);
                                    }
                                } while (method != null);
                                throw new RuntimeException("Unable to find the resolver method annotated with @CLIResolver for " + type);
                            }
                            while (!chains.isEmpty()) {
                                binders.add(new MethodBinder((Method)chains.pop(), this, parser));
                            }
                            return parser;
                        }

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public int main(List<String> args, Locale locale, InputStream stdin, PrintStream stdout, PrintStream stderr) {
                            this.stdout = stdout;
                            this.stderr = stderr;
                            this.locale = locale;
                            ArrayList<MethodBinder> binders = new ArrayList<MethodBinder>();
                            CmdLineParser parser = this.bindMethod(binders);
                            try {
                                SecurityContext sc = SecurityContextHolder.getContext();
                                Authentication old = sc.getAuthentication();
                                try {
                                    parser.parseArgument(args);
                                    Authentication auth = this.getTransportAuthentication2();
                                    sc.setAuthentication(auth);
                                    jenkins.checkPermission(Jenkins.READ);
                                    Object instance = null;
                                    for (MethodBinder binder : binders) {
                                        instance = binder.call(instance);
                                    }
                                    if (instance instanceof Integer) {
                                        int n = (Integer)instance;
                                        return n;
                                    }
                                    int n = 0;
                                    return n;
                                }
                                catch (InvocationTargetException e) {
                                    Throwable t = e.getTargetException();
                                    if (!(t instanceof Exception)) throw e;
                                    throw (Exception)t;
                                }
                                finally {
                                    sc.setAuthentication(old);
                                }
                            }
                            catch (CmdLineException e2) {
                                this.printError(e2.getMessage());
                                this.printUsage(stderr, parser);
                                return 2;
                            }
                            catch (IllegalStateException e3) {
                                this.printError(e3.getMessage());
                                return 4;
                            }
                            catch (IllegalArgumentException e4) {
                                this.printError(e4.getMessage());
                                return 3;
                            }
                            catch (AbortException e5) {
                                this.printError(e5.getMessage());
                                return 5;
                            }
                            catch (AccessDeniedException e6) {
                                this.printError(e6.getMessage());
                                return 6;
                            }
                            catch (BadCredentialsException e7) {
                                String id = UUID.randomUUID().toString();
                                this.logAndPrintError(e7, "Bad Credentials. Search the server log for " + id + " for more details.", "CLI login attempt failed: " + id, Level.INFO);
                                return 7;
                            }
                            catch (Throwable e8) {
                                String errorMsg = "Unexpected exception occurred while performing " + this.getName() + " command.";
                                this.logAndPrintError(e8, errorMsg, errorMsg, Level.WARNING);
                                Functions.printStackTrace(e8, stderr);
                                return 1;
                            }
                        }

                        private void printError(String errorMessage) {
                            this.stderr.println();
                            this.stderr.println("ERROR: " + errorMessage);
                        }

                        private void logAndPrintError(Throwable e, String errorMessage, String logMessage, Level logLevel) {
                            LOGGER.log(logLevel, logMessage, e);
                            this.printError(errorMessage);
                        }

                        @Override
                        protected int run() throws Exception {
                            throw new UnsupportedOperationException();
                        }
                    }));
                }
                catch (ClassNotFoundException | MissingResourceException e) {
                    LOGGER.log(Level.SEVERE, "Failed to process @CLIMethod: " + m, e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to discover @CLIMethod", e);
        }
        return r;
    }

    private ResourceBundleHolder loadMessageBundle(Method m) throws ClassNotFoundException {
        Class<?> c = m.getDeclaringClass();
        Class<?> msg = c.getClassLoader().loadClass(c.getName().substring(0, c.getName().lastIndexOf(".")) + ".Messages");
        return ResourceBundleHolder.get(msg);
    }
}

