/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.EnvironmentSpecific;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import hudson.util.NullStream;
import hudson.util.StreamTaskListener;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public final class JDK
extends ToolInstallation
implements NodeSpecific<JDK>,
EnvironmentSpecific<JDK> {
    public static final String DEFAULT_NAME = "(System)";
    private static final long serialVersionUID = -3318291200160313357L;
    @Deprecated
    private transient String javaHome;
    private static final Logger LOGGER = Logger.getLogger(JDK.class.getName());

    @Restricted(value={NoExternalUse.class})
    public static boolean isDefaultName(String name) {
        if ("(Default)".equals(name)) {
            return true;
        }
        return DEFAULT_NAME.equals(name) || name == null;
    }

    public JDK(String name, String javaHome) {
        super(name, javaHome, Collections.emptyList());
    }

    @DataBoundConstructor
    public JDK(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    @Deprecated
    public String getJavaHome() {
        return this.getHome();
    }

    public File getBinDir() {
        return new File(this.getHome(), "bin");
    }

    private File getExecutable() {
        String execName = File.separatorChar == '\\' ? "java.exe" : "java";
        return new File(this.getHome(), "bin/" + execName);
    }

    public boolean getExists() {
        return this.getExecutable().exists();
    }

    @Deprecated
    public void buildEnvVars(Map<String, String> env) {
        String home = this.getHome();
        if (home == null) {
            return;
        }
        env.put("PATH+JDK", home + "/bin");
        env.put("JAVA_HOME", home);
    }

    @Override
    public void buildEnvVars(EnvVars env) {
        this.buildEnvVars((Map<String, String>)env);
    }

    @Override
    public JDK forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new JDK(this.getName(), this.translateFor(node, log));
    }

    @Override
    public JDK forEnvironment(EnvVars environment) {
        return new JDK(this.getName(), environment.expand(this.getHome()));
    }

    public static boolean isDefaultJDKValid(Node n) {
        try {
            StreamTaskListener listener = new StreamTaskListener(new NullStream());
            Launcher launcher = n.createLauncher(listener);
            return launcher.launch().cmds("java", "-fullversion").stdout(listener).join() == 0;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    public static class ConverterImpl
    extends ToolInstallation.ToolConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        @Override
        protected String oldHomeField(ToolInstallation obj) {
            return ((JDK)obj).javaHome;
        }
    }

    @Extension
    @Symbol(value={"jdk"})
    public static class DescriptorImpl
    extends ToolDescriptor<JDK> {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.JDK_DisplayName();
        }

        public JDK[] getInstallations() {
            return Jenkins.get().getJDKs().toArray(new JDK[0]);
        }

        public void setInstallations(JDK ... jdks) {
            Jenkins.get().setJDKs(Arrays.asList(jdks));
        }

        @Override
        public List<? extends ToolInstaller> getDefaultInstallers() {
            try {
                Class<ToolInstaller> jdkInstallerClass = Jenkins.get().getPluginManager().uberClassLoader.loadClass("hudson.tools.JDKInstaller").asSubclass(ToolInstaller.class);
                Constructor<ToolInstaller> constructor = jdkInstallerClass.getConstructor(String.class, Boolean.TYPE);
                return List.of(constructor.newInstance(null, false));
            }
            catch (ClassNotFoundException e) {
                return Collections.emptyList();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to get default installer", e);
                return Collections.emptyList();
            }
        }

        @Override
        protected FormValidation checkHomeDirectory(File value) {
            File toolsJar = new File(value, "lib/tools.jar");
            File mac = new File(value, "lib/dt.jar");
            File javac = new File(value, "bin/javac");
            File javacExe = new File(value, "bin/javac.exe");
            if (!(toolsJar.exists() || mac.exists() || javac.exists() || javacExe.exists())) {
                return FormValidation.error(Messages.Hudson_NotJDKDir(value));
            }
            return FormValidation.ok();
        }
    }
}

