/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class StringParameterDefinition
extends SimpleParameterDefinition {
    private String defaultValue;
    private boolean trim;

    @DataBoundConstructor
    public StringParameterDefinition(@NonNull String name) {
        super(name);
    }

    public StringParameterDefinition(@NonNull String name, @CheckForNull String defaultValue, @CheckForNull String description, boolean trim) {
        this(name);
        this.setDefaultValue(defaultValue);
        this.setDescription(description);
        this.setTrim(trim);
    }

    public StringParameterDefinition(@NonNull String name, @CheckForNull String defaultValue, @CheckForNull String description) {
        this(name);
        this.setDefaultValue(defaultValue);
        this.setDescription(description);
    }

    public StringParameterDefinition(@NonNull String name, @CheckForNull String defaultValue) {
        this(name);
        this.setDefaultValue(defaultValue);
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof StringParameterValue) {
            StringParameterValue value = (StringParameterValue)defaultValue;
            return new StringParameterDefinition(this.getName(), value.value, this.getDescription());
        }
        return this;
    }

    @NonNull
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Restricted(value={DoNotUse.class})
    public String getDefaultValue4Build() {
        if (this.isTrim()) {
            return Util.fixNull(this.defaultValue).trim();
        }
        return this.defaultValue;
    }

    @DataBoundSetter
    public void setDefaultValue(@CheckForNull String defaultValue) {
        this.defaultValue = Util.fixEmpty(defaultValue);
    }

    public boolean isTrim() {
        return this.trim;
    }

    @DataBoundSetter
    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    @Override
    public StringParameterValue getDefaultParameterValue() {
        StringParameterValue value = new StringParameterValue(this.getName(), this.defaultValue, this.getDescription());
        if (this.isTrim()) {
            value.doTrim();
        }
        return value;
    }

    @Override
    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        if (this.isTrim()) {
            value.doTrim();
        }
        value.setDescription(this.getDescription());
        return value;
    }

    @Override
    public ParameterValue createValue(String str) {
        StringParameterValue value = new StringParameterValue(this.getName(), str, this.getDescription());
        if (this.isTrim()) {
            value.doTrim();
        }
        return value;
    }

    @Override
    public int hashCode() {
        if (StringParameterDefinition.class != this.getClass()) {
            return super.hashCode();
        }
        return Objects.hash(this.getName(), this.getDescription(), this.defaultValue, this.trim);
    }

    @Override
    @SuppressFBWarnings(value={"EQ_GETCLASS_AND_CLASS_CONSTANT"}, justification="ParameterDefinitionTest tests that subclasses are not equal to their parent classes, so the behavior appears to be intentional")
    public boolean equals(Object obj) {
        if (StringParameterDefinition.class != this.getClass()) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringParameterDefinition other = (StringParameterDefinition)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDescription(), other.getDescription())) {
            return false;
        }
        if (!Objects.equals(this.defaultValue, other.defaultValue)) {
            return false;
        }
        return this.trim == other.trim;
    }

    @Extension
    @Symbol(value={"string", "stringParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.StringParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/string.html";
        }
    }
}

