/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.triggers.SafeTimerTask;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="The random is just used for load distribution.")
public class DoubleLaunchChecker {
    private long lastWriteTime = 0L;
    private boolean ignore = false;
    private final Random random = new Random();
    public final File home = Jenkins.get().getRootDir();
    private String collidingId;
    private static final Logger LOGGER = Logger.getLogger(DoubleLaunchChecker.class.getName());

    protected void execute() {
        File timestampFile = new File(this.home, ".owner");
        long t = timestampFile.lastModified();
        if (t != 0L && this.lastWriteTime != 0L && t != this.lastWriteTime && !this.ignore) {
            try {
                this.collidingId = Files.readString(Util.fileToPath(timestampFile), Charset.defaultCharset());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to read collision file", e);
            }
            Jenkins.get().servletContext.setAttribute("app", (Object)this);
            LOGGER.severe("Collision detected. timestamp=" + t + ", expected=" + this.lastWriteTime);
        }
        try {
            Files.writeString(Util.fileToPath(timestampFile), (CharSequence)this.getId(), Charset.defaultCharset(), new OpenOption[0]);
            this.lastWriteTime = timestampFile.lastModified();
        }
        catch (IOException e) {
            this.lastWriteTime = 0L;
        }
        this.schedule();
    }

    public String getId() {
        return Long.toString(ProcessHandle.current().pid());
    }

    public String getCollidingId() {
        return this.collidingId;
    }

    public void schedule() {
        long MINUTE = 60000L;
        Timer.get().schedule(new SafeTimerTask(){

            @Override
            protected void doRun() {
                DoubleLaunchChecker.this.execute();
            }
        }, (long)(this.random.nextInt(30) + 60) * MINUTE, TimeUnit.MILLISECONDS);
    }

    @Initializer(after=InitMilestone.JOB_CONFIG_ADAPTED)
    public static void init() {
        new DoubleLaunchChecker().schedule();
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        rsp.setStatus(500);
        req.getView((Object)this, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @RequirePOST
    public void doIgnore(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.ignore = true;
        Jenkins.get().servletContext.setAttribute("app", (Object)Jenkins.get());
        rsp.sendRedirect2(req.getContextPath() + "/");
    }
}

