/*
 * Decompiled with CFR 0.152.
 */
package jenkins.monitor;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.security.Permission;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.monitor.Messages;
import jenkins.util.SystemProperties;
import jenkins.util.java.JavaUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Restricted(value={NoExternalUse.class})
@Symbol(value={"javaVersionRecommendation"})
public class JavaVersionRecommendationAdminMonitor
extends AdministrativeMonitor {
    private static Boolean disabled = SystemProperties.getBoolean(JavaVersionRecommendationAdminMonitor.class.getName() + ".disabled", false);

    public JavaVersionRecommendationAdminMonitor() {
        super(JavaVersionRecommendationAdminMonitor.class.getName() + "-3");
    }

    @Override
    public boolean isActivated() {
        return disabled == false && JavaUtils.isRunningWithJava8OrBelow();
    }

    @Override
    public String getDisplayName() {
        return Messages.JavaLevelAdminMonitor_DisplayName();
    }

    @Override
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }

    @Restricted(value={DoNotUse.class})
    @RequirePOST
    public HttpResponse doAct(@QueryParameter String no) throws IOException {
        if (no != null) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            this.disable(true);
            return HttpResponses.forwardToPreviousPage();
        }
        return new HttpRedirect("https://www.jenkins.io/redirect/upgrading-jenkins-java-version-8-to-11");
    }
}

