/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import hudson.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import jenkins.plugins.DetachedPluginsUtil;
import jenkins.util.MemoryReductionUtil;
import net.sf.json.JSONArray;

public class PluginLabelUtil {
    private static HashMap<String, String> renamedLabels;

    private static String canonicalLabel(String label) {
        if (renamedLabels == null) {
            renamedLabels = new HashMap();
            try (InputStream is = PluginLabelUtil.class.getResourceAsStream("/jenkins/canonical-labels.txt");){
                DetachedPluginsUtil.configLines(is).forEach(line -> {
                    String[] pieces = line.split(" ");
                    renamedLabels.put(pieces[0], pieces[1]);
                });
            }
            catch (IOException x) {
                throw new ExceptionInInitializerError(x);
            }
        }
        return renamedLabels.getOrDefault(label, label);
    }

    public static String[] canonicalLabels(JSONArray labels) {
        HashSet<String> uniqueLabels = new HashSet<String>();
        for (Object label : labels) {
            uniqueLabels.add(Util.intern(PluginLabelUtil.canonicalLabel(label.toString())));
        }
        return uniqueLabels.toArray(MemoryReductionUtil.EMPTY_STRING_ARRAY);
    }
}

