// CHECKSTYLE:OFF

package jenkins.diagnostics;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code SecurityIsOffMonitor.DisplayName}: {@code Disabled
     * Security}.
     * 
     * @return
     *     {@code Disabled Security}
     */
    public static String SecurityIsOffMonitor_DisplayName() {
        return holder.format("SecurityIsOffMonitor.DisplayName");
    }

    /**
     * Key {@code SecurityIsOffMonitor.DisplayName}: {@code Disabled
     * Security}.
     * 
     * @return
     *     {@code Disabled Security}
     */
    public static Localizable _SecurityIsOffMonitor_DisplayName() {
        return new Localizable(holder, "SecurityIsOffMonitor.DisplayName");
    }

    /**
     * Key {@code RootUrlNotSetMonitor.DisplayName}: {@code Root URL not
     * configured Monitor}.
     * 
     * @return
     *     {@code Root URL not configured Monitor}
     */
    public static String RootUrlNotSetMonitor_DisplayName() {
        return holder.format("RootUrlNotSetMonitor.DisplayName");
    }

    /**
     * Key {@code RootUrlNotSetMonitor.DisplayName}: {@code Root URL not
     * configured Monitor}.
     * 
     * @return
     *     {@code Root URL not configured Monitor}
     */
    public static Localizable _RootUrlNotSetMonitor_DisplayName() {
        return new Localizable(holder, "RootUrlNotSetMonitor.DisplayName");
    }

    /**
     * Key {@code ControllerExecutorsNoAgents.DisplayName}: {@code Built-in
     * Node Without Agents Executors Configured Monitor}.
     * 
     * @return
     *     {@code Built-in Node Without Agents Executors Configured Monitor}
     */
    public static String ControllerExecutorsNoAgents_DisplayName() {
        return holder.format("ControllerExecutorsNoAgents.DisplayName");
    }

    /**
     * Key {@code ControllerExecutorsNoAgents.DisplayName}: {@code Built-in
     * Node Without Agents Executors Configured Monitor}.
     * 
     * @return
     *     {@code Built-in Node Without Agents Executors Configured Monitor}
     */
    public static Localizable _ControllerExecutorsNoAgents_DisplayName() {
        return new Localizable(holder, "ControllerExecutorsNoAgents.DisplayName");
    }

    /**
     * Key {@code ControllerExecutorsAgents.DisplayName}: {@code Built-in
     * Node With Agents Executors Configured Monitor}.
     * 
     * @return
     *     {@code Built-in Node With Agents Executors Configured Monitor}
     */
    public static String ControllerExecutorsAgents_DisplayName() {
        return holder.format("ControllerExecutorsAgents.DisplayName");
    }

    /**
     * Key {@code ControllerExecutorsAgents.DisplayName}: {@code Built-in
     * Node With Agents Executors Configured Monitor}.
     * 
     * @return
     *     {@code Built-in Node With Agents Executors Configured Monitor}
     */
    public static Localizable _ControllerExecutorsAgents_DisplayName() {
        return new Localizable(holder, "ControllerExecutorsAgents.DisplayName");
    }

    /**
     * Key {@code CompletedInitializationMonitor.DisplayName}: {@code Jenkins
     * Initialization Monitor}.
     * 
     * @return
     *     {@code Jenkins Initialization Monitor}
     */
    public static String CompletedInitializationMonitor_DisplayName() {
        return holder.format("CompletedInitializationMonitor.DisplayName");
    }

    /**
     * Key {@code CompletedInitializationMonitor.DisplayName}: {@code Jenkins
     * Initialization Monitor}.
     * 
     * @return
     *     {@code Jenkins Initialization Monitor}
     */
    public static Localizable _CompletedInitializationMonitor_DisplayName() {
        return new Localizable(holder, "CompletedInitializationMonitor.DisplayName");
    }

    /**
     * Key {@code URICheckEncodingMonitor.DisplayName}: {@code Check URI
     * Encoding}.
     * 
     * @return
     *     {@code Check URI Encoding}
     */
    public static String URICheckEncodingMonitor_DisplayName() {
        return holder.format("URICheckEncodingMonitor.DisplayName");
    }

    /**
     * Key {@code URICheckEncodingMonitor.DisplayName}: {@code Check URI
     * Encoding}.
     * 
     * @return
     *     {@code Check URI Encoding}
     */
    public static Localizable _URICheckEncodingMonitor_DisplayName() {
        return new Localizable(holder, "URICheckEncodingMonitor.DisplayName");
    }

}
