// CHECKSTYLE:OFF

package jenkins.mvn;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code DefaultGlobalSettingsProvider.DisplayName}: {@code Use
     * default maven global settings}.
     * 
     * @return
     *     {@code Use default maven global settings}
     */
    public static String DefaultGlobalSettingsProvider_DisplayName() {
        return holder.format("DefaultGlobalSettingsProvider.DisplayName");
    }

    /**
     * Key {@code DefaultGlobalSettingsProvider.DisplayName}: {@code Use
     * default maven global settings}.
     * 
     * @return
     *     {@code Use default maven global settings}
     */
    public static Localizable _DefaultGlobalSettingsProvider_DisplayName() {
        return new Localizable(holder, "DefaultGlobalSettingsProvider.DisplayName");
    }

    /**
     * Key {@code FilePathSettingsProvider.DisplayName}: {@code Settings file
     * in filesystem}.
     * 
     * @return
     *     {@code Settings file in filesystem}
     */
    public static String FilePathSettingsProvider_DisplayName() {
        return holder.format("FilePathSettingsProvider.DisplayName");
    }

    /**
     * Key {@code FilePathSettingsProvider.DisplayName}: {@code Settings file
     * in filesystem}.
     * 
     * @return
     *     {@code Settings file in filesystem}
     */
    public static Localizable _FilePathSettingsProvider_DisplayName() {
        return new Localizable(holder, "FilePathSettingsProvider.DisplayName");
    }

    /**
     * Key {@code DefaultSettingsProvider.DisplayName}: {@code Use default
     * maven settings}.
     * 
     * @return
     *     {@code Use default maven settings}
     */
    public static String DefaultSettingsProvider_DisplayName() {
        return holder.format("DefaultSettingsProvider.DisplayName");
    }

    /**
     * Key {@code DefaultSettingsProvider.DisplayName}: {@code Use default
     * maven settings}.
     * 
     * @return
     *     {@code Use default maven settings}
     */
    public static Localizable _DefaultSettingsProvider_DisplayName() {
        return new Localizable(holder, "DefaultSettingsProvider.DisplayName");
    }

    /**
     * Key {@code FilePathGlobalSettingsProvider.DisplayName}: {@code Global
     * settings file on filesystem}.
     * 
     * @return
     *     {@code Global settings file on filesystem}
     */
    public static String FilePathGlobalSettingsProvider_DisplayName() {
        return holder.format("FilePathGlobalSettingsProvider.DisplayName");
    }

    /**
     * Key {@code FilePathGlobalSettingsProvider.DisplayName}: {@code Global
     * settings file on filesystem}.
     * 
     * @return
     *     {@code Global settings file on filesystem}
     */
    public static Localizable _FilePathGlobalSettingsProvider_DisplayName() {
        return new Localizable(holder, "FilePathGlobalSettingsProvider.DisplayName");
    }

}
