
package lib;

import java.util.Map;
import groovy.lang.Closure;
import org.kohsuke.stapler.jelly.groovy.TagFile;
import org.kohsuke.stapler.jelly.groovy.TagLibraryUri;
import org.kohsuke.stapler.jelly.groovy.TypedTagLibrary;

@TagLibraryUri("/lib/layout")
public interface LayoutTagLib
    extends TypedTagLibrary
{


    /**
     * 
     *     Creates a space for the right-hand side of the page.
     *     This sticks to the right of the page even when the content overflows.
     *   
     * 
     */
    void rightspace(Map args, Closure body);

    /**
     * 
     *     Creates a space for the right-hand side of the page.
     *     This sticks to the right of the page even when the content overflows.
     *   
     * 
     */
    void rightspace(Closure body);

    /**
     * 
     *     Creates a space for the right-hand side of the page.
     *     This sticks to the right of the page even when the content overflows.
     *   
     * 
     */
    void rightspace(Map args);

    /**
     * 
     *     Creates a space for the right-hand side of the page.
     *     This sticks to the right of the page even when the content overflows.
     *   
     * 
     */
    void rightspace();

    /**
     * 
     *         Produces a hyperlink which when clicked first asks for confirmation, then goes to that URL if confirmed.
     *         The body is displayed as the link text.
     *         @since 1.512
     *         
     *         
     *         
     *         
     *     
     * 
     */
    void confirmationLink(Map args, Closure body);

    /**
     * 
     *         Produces a hyperlink which when clicked first asks for confirmation, then goes to that URL if confirmed.
     *         The body is displayed as the link text.
     *         @since 1.512
     *         
     *         
     *         
     *         
     *     
     * 
     */
    void confirmationLink(Closure body);

    /**
     * 
     *         Produces a hyperlink which when clicked first asks for confirmation, then goes to that URL if confirmed.
     *         The body is displayed as the link text.
     *         @since 1.512
     *         
     *         
     *         
     *         
     *     
     * 
     */
    void confirmationLink(Map args);

    /**
     * 
     *         Produces a hyperlink which when clicked first asks for confirmation, then goes to that URL if confirmed.
     *         The body is displayed as the link text.
     *         @since 1.512
     *         
     *         
     *         
     *         
     *     
     * 
     */
    void confirmationLink();

    /**
     * 
     *         Declares a view as dispatchable. Views that do not use this tag or another tag that invokes this are
     *         considered fragment views and are not dispatchable.
     *         
     *     
     * 
     */
    void view(Map args, Closure body);

    /**
     * 
     *         Declares a view as dispatchable. Views that do not use this tag or another tag that invokes this are
     *         considered fragment views and are not dispatchable.
     *         
     *     
     * 
     */
    void view(Closure body);

    /**
     * 
     *         Declares a view as dispatchable. Views that do not use this tag or another tag that invokes this are
     *         considered fragment views and are not dispatchable.
     *         
     *     
     * 
     */
    void view(Map args);

    /**
     * 
     *         Declares a view as dispatchable. Views that do not use this tag or another tag that invokes this are
     *         considered fragment views and are not dispatchable.
     *         
     *     
     * 
     */
    void view();

    /**
     * 
     *     Generates a left side content as part of a Jenkins page. Typically known as two-column or left-side +  main-content layouts
     *   
     * 
     */
    @TagFile("side-panel")
    void side_panel(Map args, Closure body);

    /**
     * 
     *     Generates a left side content as part of a Jenkins page. Typically known as two-column or left-side +  main-content layouts
     *   
     * 
     */
    @TagFile("side-panel")
    void side_panel(Closure body);

    /**
     * 
     *     Generates a left side content as part of a Jenkins page. Typically known as two-column or left-side +  main-content layouts
     *   
     * 
     */
    @TagFile("side-panel")
    void side_panel(Map args);

    /**
     * 
     *     Generates a left side content as part of a Jenkins page. Typically known as two-column or left-side +  main-content layouts
     *   
     * 
     */
    @TagFile("side-panel")
    void side_panel();

    /**
     * 
     *     
     *     
     *     Generates a row containing the page title and an optional set of controls
     *   
     * 
     */
    @TagFile("app-bar")
    void app_bar(Map args, Closure body);

    /**
     * 
     *     
     *     
     *     Generates a row containing the page title and an optional set of controls
     *   
     * 
     */
    @TagFile("app-bar")
    void app_bar(Closure body);

    /**
     * 
     *     
     *     
     *     Generates a row containing the page title and an optional set of controls
     *   
     * 
     */
    @TagFile("app-bar")
    void app_bar(Map args);

    /**
     * 
     *     
     *     
     *     Generates a row containing the page title and an optional set of controls
     *   
     * 
     */
    @TagFile("app-bar")
    void app_bar();

    /**
     *  
     *     This tag inside &lt;l:tasks&gt; tag renders the left navigation bar of Jenkins.
     *     Each &lt;task&gt; tag gets an icon and link.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void task(Map args, Closure body);

    /**
     *  
     *     This tag inside &lt;l:tasks&gt; tag renders the left navigation bar of Jenkins.
     *     Each &lt;task&gt; tag gets an icon and link.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void task(Closure body);

    /**
     *  
     *     This tag inside &lt;l:tasks&gt; tag renders the left navigation bar of Jenkins.
     *     Each &lt;task&gt; tag gets an icon and link.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void task(Map args);

    /**
     *  
     *     This tag inside &lt;l:tasks&gt; tag renders the left navigation bar of Jenkins.
     *     Each &lt;task&gt; tag gets an icon and link.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void task();

    /**
     * 
     */
    void isAdmin(Map args, Closure body);

    /**
     * 
     */
    void isAdmin(Closure body);

    /**
     * 
     */
    void isAdmin(Map args);

    /**
     * 
     */
    void isAdmin();

    /**
     * 
     *     Renders the body only if the current user has the specified permission
     *     
     *     
     *   
     * 
     */
    void hasPermission(Map args, Closure body);

    /**
     * 
     *     Renders the body only if the current user has the specified permission
     *     
     *     
     *   
     * 
     */
    void hasPermission(Closure body);

    /**
     * 
     *     Renders the body only if the current user has the specified permission
     *     
     *     
     *   
     * 
     */
    void hasPermission(Map args);

    /**
     * 
     *     Renders the body only if the current user has the specified permission
     *     
     *     
     *   
     * 
     */
    void hasPermission();

    /**
     *  
     *     Display a CSS animation for progressive logging. This tag supersedes spinner.gif and is a drop in replacement:
     * 
     *     From
     *     {noformat}&lt;img src="${imagesURL}/spinner.gif" alt=""/&gt;{noformat}
     *     to
     *     {noformat}&lt;l:progressAnimation/&gt;{noformat}
     * 
     *     @since 2.320
     *     
     *   
     * 
     */
    void progressAnimation(Map args, Closure body);

    /**
     *  
     *     Display a CSS animation for progressive logging. This tag supersedes spinner.gif and is a drop in replacement:
     * 
     *     From
     *     {noformat}&lt;img src="${imagesURL}/spinner.gif" alt=""/&gt;{noformat}
     *     to
     *     {noformat}&lt;l:progressAnimation/&gt;{noformat}
     * 
     *     @since 2.320
     *     
     *   
     * 
     */
    void progressAnimation(Closure body);

    /**
     *  
     *     Display a CSS animation for progressive logging. This tag supersedes spinner.gif and is a drop in replacement:
     * 
     *     From
     *     {noformat}&lt;img src="${imagesURL}/spinner.gif" alt=""/&gt;{noformat}
     *     to
     *     {noformat}&lt;l:progressAnimation/&gt;{noformat}
     * 
     *     @since 2.320
     *     
     *   
     * 
     */
    void progressAnimation(Map args);

    /**
     *  
     *     Display a CSS animation for progressive logging. This tag supersedes spinner.gif and is a drop in replacement:
     * 
     *     From
     *     {noformat}&lt;img src="${imagesURL}/spinner.gif" alt=""/&gt;{noformat}
     *     to
     *     {noformat}&lt;l:progressAnimation/&gt;{noformat}
     * 
     *     @since 2.320
     *     
     *   
     * 
     */
    void progressAnimation();

    /**
     *  
     * 
     *         Opinionated helper to use icons via &lt;svg&gt; tags. Can be used by passing a href or a body:
     * 
     *         {noformat}
     *         # &lt;l:svgIcon href="/path/to/my/sprite.svg#my-icon" /&gt;
     *         # &lt;l:svgIcon&gt;&lt;path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"&gt;&lt;/path&gt;&lt;/l:svgIcon&gt;
     *         {noformat}
     * 
     *         @since 2.222
     *         
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     *         
     *         
     *         
     *     
     * 
     */
    void svgIcon(Map args, Closure body);

    /**
     *  
     * 
     *         Opinionated helper to use icons via &lt;svg&gt; tags. Can be used by passing a href or a body:
     * 
     *         {noformat}
     *         # &lt;l:svgIcon href="/path/to/my/sprite.svg#my-icon" /&gt;
     *         # &lt;l:svgIcon&gt;&lt;path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"&gt;&lt;/path&gt;&lt;/l:svgIcon&gt;
     *         {noformat}
     * 
     *         @since 2.222
     *         
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     *         
     *         
     *         
     *     
     * 
     */
    void svgIcon(Closure body);

    /**
     *  
     * 
     *         Opinionated helper to use icons via &lt;svg&gt; tags. Can be used by passing a href or a body:
     * 
     *         {noformat}
     *         # &lt;l:svgIcon href="/path/to/my/sprite.svg#my-icon" /&gt;
     *         # &lt;l:svgIcon&gt;&lt;path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"&gt;&lt;/path&gt;&lt;/l:svgIcon&gt;
     *         {noformat}
     * 
     *         @since 2.222
     *         
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     *         
     *         
     *         
     *     
     * 
     */
    void svgIcon(Map args);

    /**
     *  
     * 
     *         Opinionated helper to use icons via &lt;svg&gt; tags. Can be used by passing a href or a body:
     * 
     *         {noformat}
     *         # &lt;l:svgIcon href="/path/to/my/sprite.svg#my-icon" /&gt;
     *         # &lt;l:svgIcon&gt;&lt;path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"&gt;&lt;/path&gt;&lt;/l:svgIcon&gt;
     *         {noformat}
     * 
     *         @since 2.222
     *         
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     *         
     *         
     *         
     *     
     * 
     */
    void svgIcon();

    /**
     * 
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void overflowButton(Map args, Closure body);

    /**
     * 
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void overflowButton(Closure body);

    /**
     * 
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void overflowButton(Map args);

    /**
     * 
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void overflowButton();

    /**
     * 
     *         
     *         
     *     
     * 
     */
    void tabNewItem(Map args, Closure body);

    /**
     * 
     *         
     *         
     *     
     * 
     */
    void tabNewItem(Closure body);

    /**
     * 
     *         
     *         
     *     
     * 
     */
    void tabNewItem(Map args);

    /**
     * 
     *         
     *         
     *     
     * 
     */
    void tabNewItem();

    /**
     * 
     *     
     *     
     *     
     *     
     *     
     *     
     *     Creates a search input
     * 
     *     @since 2.369
     *   
     * 
     */
    @TagFile("search-bar")
    void search_bar(Map args, Closure body);

    /**
     * 
     *     
     *     
     *     
     *     
     *     
     *     
     *     Creates a search input
     * 
     *     @since 2.369
     *   
     * 
     */
    @TagFile("search-bar")
    void search_bar(Closure body);

    /**
     * 
     *     
     *     
     *     
     *     
     *     
     *     
     *     Creates a search input
     * 
     *     @since 2.369
     *   
     * 
     */
    @TagFile("search-bar")
    void search_bar(Map args);

    /**
     * 
     *     
     *     
     *     
     *     
     *     
     *     
     *     Creates a search input
     * 
     *     @since 2.369
     *   
     * 
     */
    @TagFile("search-bar")
    void search_bar();

    /**
     *  
     *     Generates the bar that shows breadcrumbs, along with its associated dynamic behaviours.
     *     This tag is used by l:layout and not expected to be used by anyone else,
     *     but it's written as separate tag for better readability of code.
     * 
     *     To render additional breadcrumb items (for example to provide in-page navigations),
     *     use the &lt;l:breadcrumb&gt; tag.
     *     
     *   
     * 
     */
    void breadcrumbBar(Map args, Closure body);

    /**
     *  
     *     Generates the bar that shows breadcrumbs, along with its associated dynamic behaviours.
     *     This tag is used by l:layout and not expected to be used by anyone else,
     *     but it's written as separate tag for better readability of code.
     * 
     *     To render additional breadcrumb items (for example to provide in-page navigations),
     *     use the &lt;l:breadcrumb&gt; tag.
     *     
     *   
     * 
     */
    void breadcrumbBar(Closure body);

    /**
     *  
     *     Generates the bar that shows breadcrumbs, along with its associated dynamic behaviours.
     *     This tag is used by l:layout and not expected to be used by anyone else,
     *     but it's written as separate tag for better readability of code.
     * 
     *     To render additional breadcrumb items (for example to provide in-page navigations),
     *     use the &lt;l:breadcrumb&gt; tag.
     *     
     *   
     * 
     */
    void breadcrumbBar(Map args);

    /**
     *  
     *     Generates the bar that shows breadcrumbs, along with its associated dynamic behaviours.
     *     This tag is used by l:layout and not expected to be used by anyone else,
     *     but it's written as separate tag for better readability of code.
     * 
     *     To render additional breadcrumb items (for example to provide in-page navigations),
     *     use the &lt;l:breadcrumb&gt; tag.
     *     
     *   
     * 
     */
    void breadcrumbBar();

    /**
     * 
     *     Outputs a help icon
     * 
     *     The help link is rendered as an SVG with an (?) icon.
     * 
     *     @since 2.234
     *     
     *     
     *     
     *   
     * 
     */
    void helpIcon(Map args, Closure body);

    /**
     * 
     *     Outputs a help icon
     * 
     *     The help link is rendered as an SVG with an (?) icon.
     * 
     *     @since 2.234
     *     
     *     
     *     
     *   
     * 
     */
    void helpIcon(Closure body);

    /**
     * 
     *     Outputs a help icon
     * 
     *     The help link is rendered as an SVG with an (?) icon.
     * 
     *     @since 2.234
     *     
     *     
     *     
     *   
     * 
     */
    void helpIcon(Map args);

    /**
     * 
     *     Outputs a help icon
     * 
     *     The help link is rendered as an SVG with an (?) icon.
     * 
     *     @since 2.234
     *     
     *     
     *     
     *   
     * 
     */
    void helpIcon();

    /**
     * 
     *         Creates a clickable "Stop" button.
     *         
     *         
     *         
     *     
     * 
     */
    void stopButton(Map args, Closure body);

    /**
     * 
     *         Creates a clickable "Stop" button.
     *         
     *         
     *         
     *     
     * 
     */
    void stopButton(Closure body);

    /**
     * 
     *         Creates a clickable "Stop" button.
     *         
     *         
     *         
     *     
     * 
     */
    void stopButton(Map args);

    /**
     * 
     *         Creates a clickable "Stop" button.
     *         
     *         
     *         
     *     
     * 
     */
    void stopButton();

    /**
     * 
     *         Retrieve the value of a given experimental flag for the current user.
     *         
     *         
     *     
     * 
     */
    void userExperimentalFlag(Map args, Closure body);

    /**
     * 
     *         Retrieve the value of a given experimental flag for the current user.
     *         
     *         
     *     
     * 
     */
    void userExperimentalFlag(Closure body);

    /**
     * 
     *         Retrieve the value of a given experimental flag for the current user.
     *         
     *         
     *     
     * 
     */
    void userExperimentalFlag(Map args);

    /**
     * 
     *         Retrieve the value of a given experimental flag for the current user.
     *         
     *         
     *     
     * 
     */
    void userExperimentalFlag();

    /**
     * 
     *         
     *         
     *         
     *     
     * 
     */
    void progressiveRendering(Map args, Closure body);

    /**
     * 
     *         
     *         
     *         
     *     
     * 
     */
    void progressiveRendering(Closure body);

    /**
     * 
     *         
     *         
     *         
     *     
     * 
     */
    void progressiveRendering(Map args);

    /**
     * 
     *         
     *         
     *         
     *     
     * 
     */
    void progressiveRendering();

    /**
     * 
     *     Send escaped value to output decorated to be safely broken into lines when necessary
     *     @since 1.517
     *     
     *   
     * 
     */
    void breakable(Map args, Closure body);

    /**
     * 
     *     Send escaped value to output decorated to be safely broken into lines when necessary
     *     @since 1.517
     *     
     *   
     * 
     */
    void breakable(Closure body);

    /**
     * 
     *     Send escaped value to output decorated to be safely broken into lines when necessary
     *     @since 1.517
     *     
     *   
     * 
     */
    void breakable(Map args);

    /**
     * 
     *     Send escaped value to output decorated to be safely broken into lines when necessary
     *     @since 1.517
     *     
     *   
     * 
     */
    void breakable();

    /**
     * 
     *     Controls checkbox selections in tables
     *   
     * 
     */
    void rowSelectionController(Map args, Closure body);

    /**
     * 
     *     Controls checkbox selections in tables
     *   
     * 
     */
    void rowSelectionController(Closure body);

    /**
     * 
     *     Controls checkbox selections in tables
     *   
     * 
     */
    void rowSelectionController(Map args);

    /**
     * 
     *     Controls checkbox selections in tables
     *   
     * 
     */
    void rowSelectionController();

    /**
     * 
     *     
     *     
     *   
     * 
     */
    void notice(Map args, Closure body);

    /**
     * 
     *     
     *     
     *   
     * 
     */
    void notice(Closure body);

    /**
     * 
     *     
     *     
     *   
     * 
     */
    void notice(Map args);

    /**
     * 
     *     
     *     
     *   
     * 
     */
    void notice();

    /**
     * 
     *     
     *     @since 2.385
     *   
     * 
     */
    void tabPane(Map args, Closure body);

    /**
     * 
     *     
     *     @since 2.385
     *   
     * 
     */
    void tabPane(Closure body);

    /**
     * 
     *     
     *     @since 2.385
     *   
     * 
     */
    void tabPane(Map args);

    /**
     * 
     *     
     *     @since 2.385
     *   
     * 
     */
    void tabPane();

    /**
     * 
     */
    void hasAdministerOrManage(Map args, Closure body);

    /**
     * 
     */
    void hasAdministerOrManage(Closure body);

    /**
     * 
     */
    void hasAdministerOrManage(Map args);

    /**
     * 
     */
    void hasAdministerOrManage();

    /**
     *  
     *     Outer-most tag for a normal (non-AJAX) HTML rendering.
     *     This is used with nested &lt;header&gt;, &lt;side-panel&gt;, and &lt;main-panel&gt;
     *     to form Jenkins's basic HTML layout.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void layout(Map args, Closure body);

    /**
     *  
     *     Outer-most tag for a normal (non-AJAX) HTML rendering.
     *     This is used with nested &lt;header&gt;, &lt;side-panel&gt;, and &lt;main-panel&gt;
     *     to form Jenkins's basic HTML layout.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void layout(Closure body);

    /**
     *  
     *     Outer-most tag for a normal (non-AJAX) HTML rendering.
     *     This is used with nested &lt;header&gt;, &lt;side-panel&gt;, and &lt;main-panel&gt;
     *     to form Jenkins's basic HTML layout.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void layout(Map args);

    /**
     *  
     *     Outer-most tag for a normal (non-AJAX) HTML rendering.
     *     This is used with nested &lt;header&gt;, &lt;side-panel&gt;, and &lt;main-panel&gt;
     *     to form Jenkins's basic HTML layout.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void layout();

    /**
     * 
     *     Load Yahoo UI module.
     *     
     *   
     * 
     */
    void yui(Map args, Closure body);

    /**
     * 
     *     Load Yahoo UI module.
     *     
     *   
     * 
     */
    void yui(Closure body);

    /**
     * 
     *     Load Yahoo UI module.
     *     
     *   
     * 
     */
    void yui(Map args);

    /**
     * 
     *     Load Yahoo UI module.
     *     
     *   
     * 
     */
    void yui();

    /**
     * Deprecated, do not use.
     * 
     */
    void isAdminOrTest(Map args, Closure body);

    /**
     * Deprecated, do not use.
     * 
     */
    void isAdminOrTest(Closure body);

    /**
     * Deprecated, do not use.
     * 
     */
    void isAdminOrTest(Map args);

    /**
     * Deprecated, do not use.
     * 
     */
    void isAdminOrTest();

    /**
     * 
     *     
     *     
     *     
     *   
     * 
     */
    void renderOnDemand(Map args, Closure body);

    /**
     * 
     *     
     *     
     *     
     *   
     * 
     */
    void renderOnDemand(Closure body);

    /**
     * 
     *     
     *     
     *     
     *   
     * 
     */
    void renderOnDemand(Map args);

    /**
     * 
     *     
     *     
     *     
     *   
     * 
     */
    void renderOnDemand();

    /**
     * 
     *     @since 1.576
     * 
     *     
     * 
     *     
     * 
     *     
     * 
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void icon(Map args, Closure body);

    /**
     * 
     *     @since 1.576
     * 
     *     
     * 
     *     
     * 
     *     
     * 
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void icon(Closure body);

    /**
     * 
     *     @since 1.576
     * 
     *     
     * 
     *     
     * 
     *     
     * 
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void icon(Map args);

    /**
     * 
     *     @since 1.576
     * 
     *     
     * 
     *     
     * 
     *     
     * 
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void icon();

    /**
     * 
     *     
     * 
     *     
     *   
     * 
     */
    void tabBar(Map args, Closure body);

    /**
     * 
     *     
     * 
     *     
     *   
     * 
     */
    void tabBar(Closure body);

    /**
     * 
     *     
     * 
     *     
     *   
     * 
     */
    void tabBar(Map args);

    /**
     * 
     *     
     * 
     *     
     *   
     * 
     */
    void tabBar();

    /**
     * 
     *     Sets up the same 'global' variables that the l:layout tag does for content loaded by AJAX scripts.
     * 
     *     
     *   
     * 
     */
    void ajax(Map args, Closure body);

    /**
     * 
     *     Sets up the same 'global' variables that the l:layout tag does for content loaded by AJAX scripts.
     * 
     *     
     *   
     * 
     */
    void ajax(Closure body);

    /**
     * 
     *     Sets up the same 'global' variables that the l:layout tag does for content loaded by AJAX scripts.
     * 
     *     
     *   
     * 
     */
    void ajax(Map args);

    /**
     * 
     *     Sets up the same 'global' variables that the l:layout tag does for content loaded by AJAX scripts.
     * 
     *     
     *   
     * 
     */
    void ajax();

    /**
     *  
     *     Used in the &lt;l:side-panel&gt; to draw a box with a title.
     * 
     *     The box is drawn as a table, and the body of this tag
     *     is expected to draw a series of &lt;TR&gt;s to fill in the contents
     *     of the box.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void pane(Map args, Closure body);

    /**
     *  
     *     Used in the &lt;l:side-panel&gt; to draw a box with a title.
     * 
     *     The box is drawn as a table, and the body of this tag
     *     is expected to draw a series of &lt;TR&gt;s to fill in the contents
     *     of the box.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void pane(Closure body);

    /**
     *  
     *     Used in the &lt;l:side-panel&gt; to draw a box with a title.
     * 
     *     The box is drawn as a table, and the body of this tag
     *     is expected to draw a series of &lt;TR&gt;s to fill in the contents
     *     of the box.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void pane(Map args);

    /**
     *  
     *     Used in the &lt;l:side-panel&gt; to draw a box with a title.
     * 
     *     The box is drawn as a table, and the body of this tag
     *     is expected to draw a series of &lt;TR&gt;s to fill in the contents
     *     of the box.
     *     
     *     
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void pane();

    /**
     * 
     *     Generates the body as the main content part of a Jenkins page.
     *   
     * 
     */
    @TagFile("main-panel")
    void main_panel(Map args, Closure body);

    /**
     * 
     *     Generates the body as the main content part of a Jenkins page.
     *   
     * 
     */
    @TagFile("main-panel")
    void main_panel(Closure body);

    /**
     * 
     *     Generates the body as the main content part of a Jenkins page.
     *   
     * 
     */
    @TagFile("main-panel")
    void main_panel(Map args);

    /**
     * 
     *     Generates the body as the main content part of a Jenkins page.
     *   
     * 
     */
    @TagFile("main-panel")
    void main_panel();

    /**
     * 
     *     Button that copies text into the user's clipboard upon click
     * 
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void copyButton(Map args, Closure body);

    /**
     * 
     *     Button that copies text into the user's clipboard upon click
     * 
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void copyButton(Closure body);

    /**
     * 
     *     Button that copies text into the user's clipboard upon click
     * 
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void copyButton(Map args);

    /**
     * 
     *     Button that copies text into the user's clipboard upon click
     * 
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void copyButton();

    /**
     * 
     *         Generates the page header, along with its associated dynamic behaviours.
     *         This tag is used by l:layout and not expected to be used by anyone else,
     *         but it's written as separate tag for better readability of code.
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     *     
     * 
     */
    void pageHeader(Map args, Closure body);

    /**
     * 
     *         Generates the page header, along with its associated dynamic behaviours.
     *         This tag is used by l:layout and not expected to be used by anyone else,
     *         but it's written as separate tag for better readability of code.
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     *     
     * 
     */
    void pageHeader(Closure body);

    /**
     * 
     *         Generates the page header, along with its associated dynamic behaviours.
     *         This tag is used by l:layout and not expected to be used by anyone else,
     *         but it's written as separate tag for better readability of code.
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     *     
     * 
     */
    void pageHeader(Map args);

    /**
     * 
     *         Generates the page header, along with its associated dynamic behaviours.
     *         This tag is used by l:layout and not expected to be used by anyone else,
     *         but it's written as separate tag for better readability of code.
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     * 
     *         
     *     
     * 
     */
    void pageHeader();

    /**
     * 
     */
    void tasks(Map args, Closure body);

    /**
     * 
     */
    void tasks(Closure body);

    /**
     * 
     */
    void tasks(Map args);

    /**
     * 
     */
    void tasks();

    /**
     *  
     *     Used inside &lt;l:layout&gt; to render additional breadcrumb items.
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void breadcrumb(Map args, Closure body);

    /**
     *  
     *     Used inside &lt;l:layout&gt; to render additional breadcrumb items.
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void breadcrumb(Closure body);

    /**
     *  
     *     Used inside &lt;l:layout&gt; to render additional breadcrumb items.
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void breadcrumb(Map args);

    /**
     *  
     *     Used inside &lt;l:layout&gt; to render additional breadcrumb items.
     *     
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void breadcrumb();

    /**
     * 
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void tab(Map args, Closure body);

    /**
     * 
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void tab(Closure body);

    /**
     * 
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void tab(Map args);

    /**
     * 
     *     
     *     
     *     
     *     
     *   
     * 
     */
    void tab();

    /**
     *  
     *     Header portion of the HTML page, that gets rendered into the &lt;head&gt; tag.
     *     Multiple &lt;l:header&gt; elements can be specified, and can even come after
     *     &lt;l:main-panel&gt;.
     * 
     *     This tag can be placed inside &lt;l:layout&gt;.
     *     
     *   
     * 
     */
    void header(Map args, Closure body);

    /**
     *  
     *     Header portion of the HTML page, that gets rendered into the &lt;head&gt; tag.
     *     Multiple &lt;l:header&gt; elements can be specified, and can even come after
     *     &lt;l:main-panel&gt;.
     * 
     *     This tag can be placed inside &lt;l:layout&gt;.
     *     
     *   
     * 
     */
    void header(Closure body);

    /**
     *  
     *     Header portion of the HTML page, that gets rendered into the &lt;head&gt; tag.
     *     Multiple &lt;l:header&gt; elements can be specified, and can even come after
     *     &lt;l:main-panel&gt;.
     * 
     *     This tag can be placed inside &lt;l:layout&gt;.
     *     
     *   
     * 
     */
    void header(Map args);

    /**
     *  
     *     Header portion of the HTML page, that gets rendered into the &lt;head&gt; tag.
     *     Multiple &lt;l:header&gt; elements can be specified, and can even come after
     *     &lt;l:main-panel&gt;.
     * 
     *     This tag can be placed inside &lt;l:layout&gt;.
     *     
     *   
     * 
     */
    void header();

    /**
     * 
     *     Customizable spinner component
     *     
     *   
     * 
     */
    void spinner(Map args, Closure body);

    /**
     * 
     *     Customizable spinner component
     *     
     *   
     * 
     */
    void spinner(Closure body);

    /**
     * 
     *     Customizable spinner component
     *     
     *   
     * 
     */
    void spinner(Map args);

    /**
     * 
     *     Customizable spinner component
     *     
     *   
     * 
     */
    void spinner();

}
