/*
 * Decompiled with CFR 0.152.
 */
package jenkins.diagnostics;

import hudson.Extension;
import hudson.Main;
import hudson.model.AdministrativeMonitor;
import java.io.IOException;
import jenkins.diagnostics.Messages;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"executorsOnBuiltInNodeWithoutAgents", "controllerExecutorsWithoutAgents"})
@Restricted(value={NoExternalUse.class})
public class ControllerExecutorsNoAgents
extends AdministrativeMonitor {
    @Override
    public String getDisplayName() {
        return Messages.ControllerExecutorsNoAgents_DisplayName();
    }

    @Override
    public boolean isSecurity() {
        return true;
    }

    @RequirePOST
    public void doAct(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.hasParameter("no")) {
            this.disable(true);
            rsp.sendRedirect(req.getContextPath() + "/manage");
        } else if (req.hasParameter("cloud")) {
            rsp.sendRedirect(req.getContextPath() + "/manage/cloud/");
        } else if (req.hasParameter("agent")) {
            rsp.sendRedirect(req.getContextPath() + "/computer/new");
        }
    }

    @Override
    public boolean isActivated() {
        return !Main.isDevelopmentMode && Jenkins.get().getNumExecutors() > 0 && Jenkins.get().clouds.isEmpty() && Jenkins.get().getNodes().isEmpty();
    }
}

