/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Lookup;
import hudson.Util;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.ConfidentialKey;
import jenkins.security.DefaultConfidentialStore;

public abstract class ConfidentialStore {
    private static final Logger LOGGER = Logger.getLogger(ConfidentialStore.class.getName());

    protected abstract void store(ConfidentialKey var1, byte[] var2) throws IOException;

    @CheckForNull
    protected abstract byte[] load(ConfidentialKey var1) throws IOException;

    abstract SecureRandom secureRandom();

    public abstract byte[] randomBytes(int var1);

    @NonNull
    public static ConfidentialStore get() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            return Mock.INSTANCE;
        }
        Lookup lookup = j.lookup;
        ConfidentialStore cs = lookup.get(ConfidentialStore.class);
        if (cs == null) {
            try {
                Iterator<ConfidentialStore> it = ServiceLoader.load(ConfidentialStore.class, ConfidentialStore.class.getClassLoader()).iterator();
                if (it.hasNext()) {
                    cs = it.next();
                }
            }
            catch (ServiceConfigurationError e) {
                LOGGER.log(Level.WARNING, "Failed to list up ConfidentialStore implementations", e);
            }
            if (cs == null) {
                try {
                    cs = new DefaultConfidentialStore();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            cs = lookup.setIfNull(ConfidentialStore.class, cs);
        }
        return cs;
    }

    static final class Mock
    extends ConfidentialStore {
        static final Mock INSTANCE = new Mock();
        private final SecureRandom rand;
        private final Map<String, byte[]> data = new ConcurrentHashMap<String, byte[]>();

        Mock() {
            try {
                this.rand = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException x) {
                throw new AssertionError("https://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#SecureRandom", x);
            }
            this.rand.setSeed(new byte[]{1, 2, 3, 4});
        }

        void clear() {
            this.data.clear();
        }

        @Override
        protected void store(ConfidentialKey key, byte[] payload) throws IOException {
            LOGGER.fine(() -> "storing " + key.getId() + " " + Util.getDigestOf(Util.toHexString(payload)));
            this.data.put(key.getId(), payload);
        }

        @Override
        protected byte[] load(ConfidentialKey key) throws IOException {
            byte[] payload = this.data.get(key.getId());
            LOGGER.fine(() -> "loading " + key.getId() + " " + (payload != null ? Util.getDigestOf(Util.toHexString(payload)) : "null"));
            return payload;
        }

        @Override
        SecureRandom secureRandom() {
            return this.rand;
        }

        @Override
        public byte[] randomBytes(int size) {
            byte[] random = new byte[size];
            this.rand.nextBytes(random);
            return random;
        }
    }
}

