/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.Util;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.slaves.SlaveComputer;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jenkins.slaves.JnlpAgentReceiver;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class EncryptedSlaveAgentJnlpFile
implements HttpResponse {
    private static final Logger LOG = Logger.getLogger(EncryptedSlaveAgentJnlpFile.class.getName());
    private static final SecureRandom RANDOM = new SecureRandom();
    private final AccessControlled it;
    private final String viewName;
    private final String slaveName;
    private final Permission connectPermission;

    public EncryptedSlaveAgentJnlpFile(AccessControlled it, String viewName, String slaveName, Permission connectPermission) {
        this.it = it;
        this.viewName = viewName;
        this.connectPermission = connectPermission;
        this.slaveName = slaveName;
    }

    public void generateResponse(StaplerRequest req, StaplerResponse res, Object node) throws IOException, ServletException {
        RequestDispatcher view = req.getView((Object)this.it, this.viewName);
        if ("true".equals(req.getParameter("encrypt"))) {
            byte[] encrypted;
            final CapturingServletOutputStream csos = new CapturingServletOutputStream();
            ResponseImpl temp = new ResponseImpl(req.getStapler(), (HttpServletResponse)new HttpServletResponseWrapper((HttpServletResponse)res){

                public ServletOutputStream getOutputStream() {
                    return csos;
                }

                public PrintWriter getWriter() {
                    throw new IllegalStateException();
                }
            });
            view.forward((ServletRequest)req, (ServletResponse)temp);
            byte[] iv = new byte[16];
            RANDOM.nextBytes(iv);
            byte[] jnlpMac = this.it instanceof SlaveComputer ? Util.fromHexString(((SlaveComputer)this.it).getJnlpMac()) : JnlpAgentReceiver.SLAVE_SECRET.mac(this.slaveName.getBytes(StandardCharsets.UTF_8));
            SecretKeySpec key = new SecretKeySpec(jnlpMac, 0, 16, "AES");
            try {
                Cipher c = Secret.getCipher("AES/CFB8/NoPadding");
                c.init(1, (Key)key, new IvParameterSpec(iv));
                encrypted = c.doFinal(csos.getBytes());
            }
            catch (GeneralSecurityException x) {
                throw new IOException(x);
            }
            res.setContentType("application/octet-stream");
            res.getOutputStream().write(iv);
            res.getOutputStream().write(encrypted);
        } else {
            this.it.checkPermission(this.connectPermission);
            view.forward((ServletRequest)req, (ServletResponse)res);
        }
    }

    private static class CapturingServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();

        private CapturingServletOutputStream() {
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
            try {
                writeListener.onWritePossible();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Failed to notify WriteListener.onWritePossible", e);
            }
        }

        public void write(int b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.baos.write(b, off, len);
        }

        byte[] getBytes() {
            return this.baos.toByteArray();
        }
    }
}

