// CHECKSTYLE:OFF

package hudson.logging;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code LogRecorder.Target.Empty.Warning}: {@code Setting the Root
     * (empty) logger to FINE or below is strongly discouraged as it
     * excessively hurts performances. It may well crash Jenkins and prevent
     * it to start.}.
     * 
     * @return
     *     {@code Setting the Root (empty) logger to FINE or below is strongly
     *     discouraged as it excessively hurts performances. It may well crash
     *     Jenkins and prevent it to start.}
     */
    public static String LogRecorder_Target_Empty_Warning() {
        return holder.format("LogRecorder.Target.Empty.Warning");
    }

    /**
     * Key {@code LogRecorder.Target.Empty.Warning}: {@code Setting the Root
     * (empty) logger to FINE or below is strongly discouraged as it
     * excessively hurts performances. It may well crash Jenkins and prevent
     * it to start.}.
     * 
     * @return
     *     {@code Setting the Root (empty) logger to FINE or below is strongly
     *     discouraged as it excessively hurts performances. It may well crash
     *     Jenkins and prevent it to start.}
     */
    public static Localizable _LogRecorder_Target_Empty_Warning() {
        return new Localizable(holder, "LogRecorder.Target.Empty.Warning");
    }

    /**
     * Key {@code LogRecorderManager.DisplayName}: {@code System Log}.
     * 
     * @return
     *     {@code System Log}
     */
    public static String LogRecorderManager_DisplayName() {
        return holder.format("LogRecorderManager.DisplayName");
    }

    /**
     * Key {@code LogRecorderManager.DisplayName}: {@code System Log}.
     * 
     * @return
     *     {@code System Log}
     */
    public static Localizable _LogRecorderManager_DisplayName() {
        return new Localizable(holder, "LogRecorderManager.DisplayName");
    }

    /**
     * Key {@code LogRecorderManager.LoggerNotFound}: {@code A logger named
     * "{0}" does not exist. Add a logger by this name to a log recorder
     * before attempting to configure its level.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A logger named "{0}" does not exist. Add a logger by this name
     *     to a log recorder before attempting to configure its level.}
     */
    public static String LogRecorderManager_LoggerNotFound(Object arg0) {
        return holder.format("LogRecorderManager.LoggerNotFound", arg0);
    }

    /**
     * Key {@code LogRecorderManager.LoggerNotFound}: {@code A logger named
     * "{0}" does not exist. Add a logger by this name to a log recorder
     * before attempting to configure its level.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A logger named "{0}" does not exist. Add a logger by this name
     *     to a log recorder before attempting to configure its level.}
     */
    public static Localizable _LogRecorderManager_LoggerNotFound(Object arg0) {
        return new Localizable(holder, "LogRecorderManager.LoggerNotFound", arg0);
    }

    /**
     * Key {@code LogRecorderManager.init}: {@code Initializing log
     * recorders}.
     * 
     * @return
     *     {@code Initializing log recorders}
     */
    public static String LogRecorderManager_init() {
        return holder.format("LogRecorderManager.init");
    }

    /**
     * Key {@code LogRecorderManager.init}: {@code Initializing log
     * recorders}.
     * 
     * @return
     *     {@code Initializing log recorders}
     */
    public static Localizable _LogRecorderManager_init() {
        return new Localizable(holder, "LogRecorderManager.init");
    }

}
