/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.security.ACL;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.AccessControlled;
import hudson.security.AccountCreationFailedException;
import hudson.security.AuthorizationStrategy;
import hudson.security.FederatedLoginService;
import hudson.security.GroupDetails;
import hudson.security.Messages;
import hudson.security.Permission;
import hudson.security.PermissionAdder;
import hudson.security.SecurityRealm;
import hudson.security.captcha.CaptchaSupport;
import hudson.util.FormValidation;
import hudson.util.PluginServletFilter;
import hudson.util.Protector;
import hudson.util.Scrambler;
import hudson.util.XStream2;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import jenkins.security.seed.UserSeedProperty;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.acegisecurity.GrantedAuthority;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.mindrot.jbcrypt.BCrypt;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;

public class HudsonPrivateSecurityRealm
extends AbstractPasswordBasedSecurityRealm
implements ModelObject,
AccessControlled {
    private static String ID_REGEX = System.getProperty(HudsonPrivateSecurityRealm.class.getName() + ".ID_REGEX");
    private static final String DEFAULT_ID_REGEX = "^[\\w-]+$";
    private final boolean disableSignup;
    private final boolean enableCaptcha;
    private static final String FEDERATED_IDENTITY_SESSION_KEY = HudsonPrivateSecurityRealm.class.getName() + ".federatedIdentity";
    private static final Collection<? extends org.springframework.security.core.GrantedAuthority> TEST_AUTHORITY = Set.of(AUTHENTICATED_AUTHORITY2);
    static final JBCryptEncoder JBCRYPT_ENCODER = new JBCryptEncoder();
    public static final MultiPasswordEncoder PASSWORD_ENCODER = new MultiPasswordEncoder();
    private static final String ENCODED_INVALID_USER_PASSWORD = PASSWORD_ENCODER.encode(HudsonPrivateSecurityRealm.generatePassword());
    private static final Filter CREATE_FIRST_USER_FILTER = new Filter(){

        public void init(FilterConfig config) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest req = (HttpServletRequest)request;
            if (req.getRequestURI().equals(req.getContextPath() + "/") || req.getRequestURI().equals(req.getContextPath() + "/manage")) {
                if (this.needsToCreateFirstUser()) {
                    ((HttpServletResponse)response).sendRedirect("securityRealm/firstUser");
                } else {
                    PluginServletFilter.removeFilter(this);
                    chain.doFilter(request, response);
                }
            } else {
                chain.doFilter(request, response);
            }
        }

        private boolean needsToCreateFirstUser() {
            return !HudsonPrivateSecurityRealm.hasSomeUser() && Jenkins.get().getSecurityRealm() instanceof HudsonPrivateSecurityRealm;
        }

        public void destroy() {
        }
    };
    private static final Logger LOGGER = Logger.getLogger(HudsonPrivateSecurityRealm.class.getName());

    @Deprecated
    public HudsonPrivateSecurityRealm(boolean allowsSignup) {
        this(allowsSignup, false, null);
    }

    @DataBoundConstructor
    public HudsonPrivateSecurityRealm(boolean allowsSignup, boolean enableCaptcha, CaptchaSupport captchaSupport) {
        this.disableSignup = !allowsSignup;
        this.enableCaptcha = enableCaptcha;
        this.setCaptchaSupport(captchaSupport);
        if (!allowsSignup && !HudsonPrivateSecurityRealm.hasSomeUser()) {
            try {
                PluginServletFilter.addFilter(CREATE_FIRST_USER_FILTER);
            }
            catch (ServletException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public boolean allowsSignup() {
        return !this.disableSignup;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean getAllowsSignup() {
        return this.allowsSignup();
    }

    public boolean isEnableCaptcha() {
        return this.enableCaptcha;
    }

    private static boolean hasSomeUser() {
        for (User u : User.getAll()) {
            if (u.getProperty(Details.class) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public GroupDetails loadGroupByGroupname2(String groupname, boolean fetchMembers) throws UsernameNotFoundException {
        throw new UsernameNotFoundException(groupname);
    }

    @Override
    public UserDetails loadUserByUsername2(String username) throws UsernameNotFoundException {
        return this.load(username).asUserDetails();
    }

    @Restricted(value={NoExternalUse.class})
    public Details load(String username) throws UsernameNotFoundException {
        Details p;
        User u = User.getById(username, false);
        Details details = p = u != null ? u.getProperty(Details.class) : null;
        if (p == null) {
            throw new UsernameNotFoundException("Password is not set: " + username);
        }
        if (p.getUser() == null) {
            throw new AssertionError();
        }
        return p;
    }

    @Override
    protected UserDetails authenticate2(String username, String password) throws AuthenticationException {
        Details u;
        try {
            u = this.load(username);
        }
        catch (UsernameNotFoundException ex) {
            PASSWORD_ENCODER.matches(password, ENCODED_INVALID_USER_PASSWORD);
            throw ex;
        }
        if (!u.isPasswordCorrect(password)) {
            throw new BadCredentialsException("Bad credentials");
        }
        return u.asUserDetails();
    }

    @Override
    public HttpResponse commenceSignup(final FederatedLoginService.FederatedIdentity identity) {
        Stapler.getCurrentRequest().getSession().setAttribute(FEDERATED_IDENTITY_SESSION_KEY, (Object)identity);
        return new ForwardToView(this, "signupWithFederatedIdentity.jelly"){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                SignupInfo si = new SignupInfo(identity);
                si.errorMessage = Messages.HudsonPrivateSecurityRealm_WouldYouLikeToSignUp(identity.getPronoun(), identity.getIdentifier());
                req.setAttribute("data", (Object)si);
                super.generateResponse(req, rsp, node);
            }
        };
    }

    @RequirePOST
    public User doCreateAccountWithFederatedIdentity(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        User u = this._doCreateAccount(req, rsp, "signupWithFederatedIdentity.jelly");
        if (u != null) {
            ((FederatedLoginService.FederatedIdentity)req.getSession().getAttribute(FEDERATED_IDENTITY_SESSION_KEY)).addTo(u);
        }
        return u;
    }

    @RequirePOST
    public User doCreateAccount(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        return this._doCreateAccount(req, rsp, "signup.jelly");
    }

    private User _doCreateAccount(StaplerRequest req, StaplerResponse rsp, String formView) throws ServletException, IOException {
        if (!this.allowsSignup()) {
            throw HttpResponses.errorWithoutStack((int)401, (String)"User sign up is prohibited");
        }
        boolean firstUser = !HudsonPrivateSecurityRealm.hasSomeUser();
        User u = this.createAccount(req, rsp, this.enableCaptcha, formView);
        if (u != null) {
            if (firstUser) {
                this.tryToMakeAdmin(u);
            }
            this.loginAndTakeBack(req, rsp, u);
        }
        return u;
    }

    private void loginAndTakeBack(StaplerRequest req, StaplerResponse rsp, User u) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        req.getSession(true);
        UsernamePasswordAuthenticationToken a = new UsernamePasswordAuthenticationToken((Object)u.getId(), (Object)req.getParameter("password1"));
        a = this.getSecurityComponents().manager2.authenticate((Authentication)a);
        SecurityContextHolder.getContext().setAuthentication((Authentication)a);
        SecurityListener.fireLoggedIn(u.getId());
        req.getView((Object)this, "success.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @RequirePOST
    public void doCreateAccountByAdmin(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.createAccountByAdmin(req, rsp, "addUser.jelly", ".");
    }

    @Restricted(value={NoExternalUse.class})
    public User createAccountByAdmin(StaplerRequest req, StaplerResponse rsp, String addUserView, String successView) throws IOException, ServletException {
        this.checkPermission(Jenkins.ADMINISTER);
        User u = this.createAccount(req, rsp, false, addUserView);
        if (u != null && successView != null) {
            rsp.sendRedirect(successView);
        }
        return u;
    }

    @Restricted(value={NoExternalUse.class})
    public User createAccountFromSetupWizard(StaplerRequest req) throws IOException, AccountCreationFailedException {
        this.checkPermission(Jenkins.ADMINISTER);
        SignupInfo si = this.validateAccountCreationForm(req, false);
        if (!si.errors.isEmpty()) {
            String messages = this.getErrorMessages(si);
            throw new AccountCreationFailedException(messages);
        }
        return this.createAccount(si);
    }

    private String getErrorMessages(SignupInfo si) {
        StringBuilder messages = new StringBuilder();
        for (String message : si.errors.values()) {
            messages.append(message).append(" | ");
        }
        return messages.toString();
    }

    @RequirePOST
    public void doCreateFirstAccount(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (HudsonPrivateSecurityRealm.hasSomeUser()) {
            rsp.sendError(401, "First user was already created");
            return;
        }
        User u = this.createAccount(req, rsp, false, "firstUser.jelly");
        if (u != null) {
            this.tryToMakeAdmin(u);
            this.loginAndTakeBack(req, rsp, u);
        }
    }

    private void tryToMakeAdmin(User u) {
        AuthorizationStrategy as = Jenkins.get().getAuthorizationStrategy();
        for (PermissionAdder adder : ExtensionList.lookup(PermissionAdder.class)) {
            if (!adder.add(as, u, Jenkins.ADMINISTER)) continue;
            return;
        }
    }

    private User createAccount(StaplerRequest req, StaplerResponse rsp, boolean validateCaptcha, String formView) throws ServletException, IOException {
        SignupInfo si = this.validateAccountCreationForm(req, validateCaptcha);
        if (!si.errors.isEmpty()) {
            req.getView((Object)this, formView).forward((ServletRequest)req, (ServletResponse)rsp);
            return null;
        }
        return this.createAccount(si);
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="written to by Stapler")
    private SignupInfo validateAccountCreationForm(StaplerRequest req, boolean validateCaptcha) {
        SignupInfo si = new SignupInfo(req);
        if (validateCaptcha && !this.validateCaptcha(si.captcha)) {
            si.errors.put("captcha", Messages.HudsonPrivateSecurityRealm_CreateAccount_TextNotMatchWordInImage());
        }
        if (si.username == null || si.username.isEmpty()) {
            si.errors.put("username", Messages.HudsonPrivateSecurityRealm_CreateAccount_UserNameRequired());
        } else if (!this.containsOnlyAcceptableCharacters(si.username)) {
            if (ID_REGEX == null) {
                si.errors.put("username", Messages.HudsonPrivateSecurityRealm_CreateAccount_UserNameInvalidCharacters());
            } else {
                si.errors.put("username", Messages.HudsonPrivateSecurityRealm_CreateAccount_UserNameInvalidCharactersCustom(ID_REGEX));
            }
        } else {
            User user = User.getById(si.username, false);
            if (null != user && user.getProperty(Details.class) != null) {
                si.errors.put("username", Messages.HudsonPrivateSecurityRealm_CreateAccount_UserNameAlreadyTaken());
            }
        }
        if (si.password1 != null && !si.password1.equals(si.password2)) {
            si.errors.put("password1", Messages.HudsonPrivateSecurityRealm_CreateAccount_PasswordNotMatch());
        }
        if (si.password1 == null || si.password1.length() == 0) {
            si.errors.put("password1", Messages.HudsonPrivateSecurityRealm_CreateAccount_PasswordRequired());
        }
        if (si.fullname == null || si.fullname.isEmpty()) {
            si.fullname = si.username;
        }
        if (this.isMailerPluginPresent() && (si.email == null || !si.email.contains("@"))) {
            si.errors.put("email", Messages.HudsonPrivateSecurityRealm_CreateAccount_InvalidEmailAddress());
        }
        if (!User.isIdOrFullnameAllowed(si.username)) {
            si.errors.put("username", hudson.model.Messages.User_IllegalUsername(si.username));
        }
        if (!User.isIdOrFullnameAllowed(si.fullname)) {
            si.errors.put("fullname", hudson.model.Messages.User_IllegalFullname(si.fullname));
        }
        req.setAttribute("data", (Object)si);
        return si;
    }

    private User createAccount(SignupInfo si) throws IOException {
        if (!si.errors.isEmpty()) {
            String messages = this.getErrorMessages(si);
            throw new IllegalArgumentException("invalid signup info passed to createAccount(si): " + messages);
        }
        User user = this.createAccount(si.username, si.password1);
        user.setFullName(si.fullname);
        if (this.isMailerPluginPresent()) {
            try {
                Class<?> up = Jenkins.get().pluginManager.uberClassLoader.loadClass("hudson.tasks.Mailer$UserProperty");
                Constructor<?> c = up.getDeclaredConstructor(String.class);
                user.addProperty((UserProperty)c.newInstance(si.email));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        user.save();
        return user;
    }

    private boolean containsOnlyAcceptableCharacters(@NonNull String value) {
        if (ID_REGEX == null) {
            return value.matches(DEFAULT_ID_REGEX);
        }
        return value.matches(ID_REGEX);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isMailerPluginPresent() {
        try {
            return null != Jenkins.get().pluginManager.uberClassLoader.loadClass("hudson.tasks.Mailer$UserProperty");
        }
        catch (ClassNotFoundException e) {
            LOGGER.finer("Mailer plugin not present");
            return false;
        }
    }

    public User createAccount(String userName, String password) throws IOException {
        User user = User.getById(userName, true);
        user.addProperty(Details.fromPlainPassword(password));
        SecurityListener.fireUserCreated(user.getId());
        return user;
    }

    public User createAccountWithHashedPassword(String userName, String hashedPassword) throws IOException {
        if (!PASSWORD_ENCODER.isPasswordHashed(hashedPassword)) {
            throw new IllegalArgumentException("this method should only be called with a pre-hashed password");
        }
        User user = User.getById(userName, true);
        user.addProperty(Details.fromHashedPassword(hashedPassword));
        SecurityListener.fireUserCreated(user.getId());
        return user;
    }

    @Override
    public String getDisplayName() {
        return Messages.HudsonPrivateSecurityRealm_DisplayName();
    }

    @Override
    public ACL getACL() {
        return Jenkins.get().getACL();
    }

    @Override
    public void checkPermission(Permission permission) {
        Jenkins.get().checkPermission(permission);
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return Jenkins.get().hasPermission(permission);
    }

    public List<User> getAllUsers() {
        ArrayList<User> r = new ArrayList<User>();
        for (User u : User.getAll()) {
            if (u.getProperty(Details.class) == null) continue;
            r.add(u);
        }
        Collections.sort(r);
        return r;
    }

    @Restricted(value={NoExternalUse.class})
    public User getUser(String id) {
        return User.getById(id, User.ALLOW_USER_CREATION_VIA_URL && this.hasPermission(Jenkins.ADMINISTER));
    }

    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE", "PREDICTABLE_RANDOM"}, justification="https://github.com/spotbugs/spotbugs/issues/1539 and doesn't need to be secure, we're just not hardcoding a 'wrong' password")
    private static String generatePassword() {
        String password = new Random().ints(20L, 33, 127).mapToObj(i -> Character.valueOf((char)i)).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        return password;
    }

    @Extension
    @Symbol(value={"local"})
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.HudsonPrivateSecurityRealm_DisplayName();
        }

        public FormValidation doCheckAllowsSignup(@QueryParameter boolean value) {
            if (value) {
                return FormValidation.warning(Messages.HudsonPrivateSecurityRealm_SignupWarning());
            }
            return FormValidation.ok();
        }
    }

    static class MultiPasswordEncoder
    implements PasswordEncoder {
        private static final String JBCRYPT_HEADER = "#jbcrypt:";

        MultiPasswordEncoder() {
        }

        public String encode(CharSequence rawPassword) {
            return JBCRYPT_HEADER + JBCRYPT_ENCODER.encode(rawPassword);
        }

        public boolean matches(CharSequence rawPassword, String encPass) {
            if (this.isPasswordHashed(encPass)) {
                return JBCRYPT_ENCODER.matches(rawPassword, encPass.substring(JBCRYPT_HEADER.length()));
            }
            return false;
        }

        public boolean isPasswordHashed(String password) {
            if (password == null) {
                return false;
            }
            return password.startsWith(JBCRYPT_HEADER) && JBCRYPT_ENCODER.isHashValid(password.substring(JBCRYPT_HEADER.length()));
        }
    }

    private static class JBCryptEncoder
    implements PasswordEncoder {
        @Restricted(value={NoExternalUse.class})
        @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
        private static int MAXIMUM_BCRYPT_LOG_ROUND = SystemProperties.getInteger(HudsonPrivateSecurityRealm.class.getName() + ".maximumBCryptLogRound", 18);
        private static final Pattern BCRYPT_PATTERN = Pattern.compile("^\\$2a\\$([0-9]{2})\\$.{53}$");

        private JBCryptEncoder() {
        }

        public String encode(CharSequence rawPassword) {
            return BCrypt.hashpw((String)rawPassword.toString(), (String)BCrypt.gensalt());
        }

        public boolean matches(CharSequence rawPassword, String encodedPassword) {
            return BCrypt.checkpw((String)rawPassword.toString(), (String)encodedPassword);
        }

        public boolean isHashValid(String hash) {
            String logNumOfRound;
            int logNumOfRoundInt;
            Matcher matcher = BCRYPT_PATTERN.matcher(hash);
            return matcher.matches() && (logNumOfRoundInt = Integer.parseInt(logNumOfRound = matcher.group(1))) > 0 && logNumOfRoundInt <= MAXIMUM_BCRYPT_LOG_ROUND;
        }
    }

    @Extension
    @Symbol(value={"localUsers"})
    public static final class ManageUserLinks
    extends ManagementLink {
        @Override
        public String getIconFileName() {
            if (Jenkins.get().getSecurityRealm() instanceof HudsonPrivateSecurityRealm) {
                return "symbol-people";
            }
            return null;
        }

        @Override
        public String getUrlName() {
            return "securityRealm/";
        }

        @Override
        public String getDisplayName() {
            return Messages.HudsonPrivateSecurityRealm_ManageUserLinks_DisplayName();
        }

        @Override
        public String getDescription() {
            return Messages.HudsonPrivateSecurityRealm_ManageUserLinks_Description();
        }

        @Override
        @NonNull
        public ManagementLink.Category getCategory() {
            return ManagementLink.Category.SECURITY;
        }
    }

    public static final class Details
    extends UserProperty {
        private String passwordHash;
        @Deprecated
        private transient String password;

        private Details(String passwordHash) {
            this.passwordHash = passwordHash;
        }

        static Details fromHashedPassword(String hashed) {
            return new Details(hashed);
        }

        static Details fromPlainPassword(String rawPassword) {
            return new Details(PASSWORD_ENCODER.encode(rawPassword));
        }

        public Collection<? extends org.springframework.security.core.GrantedAuthority> getAuthorities2() {
            return TEST_AUTHORITY;
        }

        @Deprecated
        public GrantedAuthority[] getAuthorities() {
            return GrantedAuthority.fromSpring(this.getAuthorities2());
        }

        public String getPassword() {
            return this.passwordHash;
        }

        public boolean isPasswordCorrect(String candidate) {
            return PASSWORD_ENCODER.matches(candidate, this.getPassword());
        }

        public String getProtectedPassword() {
            return Protector.protect(Stapler.getCurrentRequest().getSession().getId() + ":" + this.getPassword());
        }

        public String getUsername() {
            return this.user.getId();
        }

        User getUser() {
            return this.user;
        }

        public boolean isAccountNonExpired() {
            return true;
        }

        public boolean isAccountNonLocked() {
            return true;
        }

        public boolean isCredentialsNonExpired() {
            return true;
        }

        public boolean isEnabled() {
            return true;
        }

        UserDetails asUserDetails() {
            return new UserDetailsImpl();
        }

        @Extension
        @Symbol(value={"password"})
        public static final class DescriptorImpl
        extends UserPropertyDescriptor {
            @Override
            @NonNull
            public String getDisplayName() {
                return Messages.HudsonPrivateSecurityRealm_Details_DisplayName();
            }

            @Override
            public Details newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
                String prefix;
                String data2;
                if (req == null) {
                    throw new Descriptor.FormException("Stapler request is missing in the call", "staplerRequest");
                }
                String pwd = Util.fixEmpty(req.getParameter("user.password"));
                String pwd2 = Util.fixEmpty(req.getParameter("user.password2"));
                if (pwd == null || pwd2 == null) {
                    throw new Descriptor.FormException("Please confirm the password by typing it twice", "user.password2");
                }
                String data = Protector.unprotect(pwd);
                if (data == null != ((data2 = Protector.unprotect(pwd2)) == null)) {
                    throw new Descriptor.FormException("Please confirm the password by typing it twice", "user.password2");
                }
                if (data != null && !MessageDigest.isEqual(data.getBytes(StandardCharsets.UTF_8), data2.getBytes(StandardCharsets.UTF_8))) {
                    throw new Descriptor.FormException("Please confirm the password by typing it twice", "user.password2");
                }
                if (data == null && !pwd.equals(pwd2)) {
                    throw new Descriptor.FormException("Please confirm the password by typing it twice", "user.password2");
                }
                if (data != null && data.startsWith(prefix = Stapler.getCurrentRequest().getSession().getId() + ":")) {
                    return Details.fromHashedPassword(data.substring(prefix.length()));
                }
                User user = Util.getNearestAncestorOfTypeOrThrow(req, User.class);
                UserSeedProperty userSeedProperty = user.getProperty(UserSeedProperty.class);
                if (userSeedProperty != null) {
                    userSeedProperty.renewSeed();
                }
                return Details.fromPlainPassword(Util.fixNull(pwd));
            }

            @Override
            public boolean isEnabled() {
                return Jenkins.get().getSecurityRealm() instanceof HudsonPrivateSecurityRealm;
            }

            @Override
            public UserProperty newInstance(User user) {
                return null;
            }
        }

        public static class ConverterImpl
        extends XStream2.PassthruConverter<Details> {
            public ConverterImpl(XStream2 xstream) {
                super(xstream);
            }

            @Override
            protected void callback(Details d, UnmarshallingContext context) {
                if (d.password != null && d.passwordHash == null) {
                    d.passwordHash = PASSWORD_ENCODER.encode(Scrambler.descramble(d.password));
                    OldDataMonitor.report(context, "1.283");
                }
            }
        }

        private final class UserDetailsImpl
        implements UserDetails {
            private UserDetailsImpl() {
            }

            public Collection<? extends org.springframework.security.core.GrantedAuthority> getAuthorities() {
                return Details.this.getAuthorities2();
            }

            public String getPassword() {
                return Details.this.getPassword();
            }

            public String getUsername() {
                return Details.this.getUsername();
            }

            public boolean isAccountNonExpired() {
                return Details.this.isAccountNonExpired();
            }

            public boolean isAccountNonLocked() {
                return Details.this.isAccountNonLocked();
            }

            public boolean isCredentialsNonExpired() {
                return Details.this.isCredentialsNonExpired();
            }

            public boolean isEnabled() {
                return Details.this.isEnabled();
            }

            public boolean equals(Object o) {
                return o instanceof UserDetailsImpl && ((UserDetailsImpl)o).getUsername().equals(this.getUsername());
            }

            public int hashCode() {
                return this.getUsername().hashCode();
            }
        }
    }

    public static final class SignupInfo {
        public String username;
        public String password1;
        public String password2;
        public String fullname;
        public String email;
        public String captcha;
        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="read by Stapler")
        public String errorMessage;
        public HashMap<String, String> errors = new HashMap();

        public SignupInfo() {
        }

        public SignupInfo(StaplerRequest req) {
            req.bindParameters((Object)this);
        }

        public SignupInfo(FederatedLoginService.FederatedIdentity i) {
            this.username = i.getNickname();
            this.fullname = i.getFullName();
            this.email = i.getEmailAddress();
        }
    }
}

