// CHECKSTYLE:OFF

package hudson.node_monitors;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ResponseTimeMonitor.TimeOut}: {@code Timed out for last {0}
     * attempts}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Timed out for last {0} attempts}
     */
    public static String ResponseTimeMonitor_TimeOut(Object arg0) {
        return holder.format("ResponseTimeMonitor.TimeOut", arg0);
    }

    /**
     * Key {@code ResponseTimeMonitor.TimeOut}: {@code Timed out for last {0}
     * attempts}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Timed out for last {0} attempts}
     */
    public static Localizable _ResponseTimeMonitor_TimeOut(Object arg0) {
        return new Localizable(holder, "ResponseTimeMonitor.TimeOut", arg0);
    }

    /**
     * Key {@code ArchitectureMonitor.DisplayName}: {@code Architecture}.
     * 
     * @return
     *     {@code Architecture}
     */
    public static String ArchitectureMonitor_DisplayName() {
        return holder.format("ArchitectureMonitor.DisplayName");
    }

    /**
     * Key {@code ArchitectureMonitor.DisplayName}: {@code Architecture}.
     * 
     * @return
     *     {@code Architecture}
     */
    public static Localizable _ArchitectureMonitor_DisplayName() {
        return new Localizable(holder, "ArchitectureMonitor.DisplayName");
    }

    /**
     * Key {@code DiskSpaceMonitorDescriptor.DiskSpace.FreeSpace}: {@code {0}
     * out of {2} left on {1}.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} out of {2} left on {1}.}
     */
    public static String DiskSpaceMonitorDescriptor_DiskSpace_FreeSpace(Object arg0, Object arg1, Object arg2) {
        return holder.format("DiskSpaceMonitorDescriptor.DiskSpace.FreeSpace", arg0, arg1, arg2);
    }

    /**
     * Key {@code DiskSpaceMonitorDescriptor.DiskSpace.FreeSpace}: {@code {0}
     * out of {2} left on {1}.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} out of {2} left on {1}.}
     */
    public static Localizable _DiskSpaceMonitorDescriptor_DiskSpace_FreeSpace(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "DiskSpaceMonitorDescriptor.DiskSpace.FreeSpace", arg0, arg1, arg2);
    }

    /**
     * Key {@code DiskSpaceMonitorNodeProperty.DisplayName}: {@code Disk
     * Space Monitoring Thresholds}.
     * 
     * @return
     *     {@code Disk Space Monitoring Thresholds}
     */
    public static String DiskSpaceMonitorNodeProperty_DisplayName() {
        return holder.format("DiskSpaceMonitorNodeProperty.DisplayName");
    }

    /**
     * Key {@code DiskSpaceMonitorNodeProperty.DisplayName}: {@code Disk
     * Space Monitoring Thresholds}.
     * 
     * @return
     *     {@code Disk Space Monitoring Thresholds}
     */
    public static Localizable _DiskSpaceMonitorNodeProperty_DisplayName() {
        return new Localizable(holder, "DiskSpaceMonitorNodeProperty.DisplayName");
    }

    /**
     * Key {@code DiskSpaceMonitor.MarkedOnline}: {@code Putting {0} back
     * online as there is enough disk space again}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Putting {0} back online as there is enough disk space again}
     */
    public static String DiskSpaceMonitor_MarkedOnline(Object arg0) {
        return holder.format("DiskSpaceMonitor.MarkedOnline", arg0);
    }

    /**
     * Key {@code DiskSpaceMonitor.MarkedOnline}: {@code Putting {0} back
     * online as there is enough disk space again}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Putting {0} back online as there is enough disk space again}
     */
    public static Localizable _DiskSpaceMonitor_MarkedOnline(Object arg0) {
        return new Localizable(holder, "DiskSpaceMonitor.MarkedOnline", arg0);
    }

    /**
     * Key {@code DiskSpaceMonitor.DisplayName}: {@code Free Disk Space}.
     * 
     * @return
     *     {@code Free Disk Space}
     */
    public static String DiskSpaceMonitor_DisplayName() {
        return holder.format("DiskSpaceMonitor.DisplayName");
    }

    /**
     * Key {@code DiskSpaceMonitor.DisplayName}: {@code Free Disk Space}.
     * 
     * @return
     *     {@code Free Disk Space}
     */
    public static Localizable _DiskSpaceMonitor_DisplayName() {
        return new Localizable(holder, "DiskSpaceMonitor.DisplayName");
    }

    /**
     * Key {@code ResponseTimeMonitor.MarkedOffline}: {@code Making {0}
     * offline because it is not responding}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Making {0} offline because it is not responding}
     */
    public static String ResponseTimeMonitor_MarkedOffline(Object arg0) {
        return holder.format("ResponseTimeMonitor.MarkedOffline", arg0);
    }

    /**
     * Key {@code ResponseTimeMonitor.MarkedOffline}: {@code Making {0}
     * offline because it is not responding}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Making {0} offline because it is not responding}
     */
    public static Localizable _ResponseTimeMonitor_MarkedOffline(Object arg0) {
        return new Localizable(holder, "ResponseTimeMonitor.MarkedOffline", arg0);
    }

    /**
     * Key {@code TemporarySpaceMonitor.DisplayName}: {@code Free Temp
     * Space}.
     * 
     * @return
     *     {@code Free Temp Space}
     */
    public static String TemporarySpaceMonitor_DisplayName() {
        return holder.format("TemporarySpaceMonitor.DisplayName");
    }

    /**
     * Key {@code TemporarySpaceMonitor.DisplayName}: {@code Free Temp
     * Space}.
     * 
     * @return
     *     {@code Free Temp Space}
     */
    public static Localizable _TemporarySpaceMonitor_DisplayName() {
        return new Localizable(holder, "TemporarySpaceMonitor.DisplayName");
    }

    /**
     * Key {@code DiskSpaceMonitorDescriptor.DiskSpace.FreeSpaceTooLow}:
     * {@code Disk space is below threshold of {2}. Only {0} out of {3} left
     * on {1}.}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Disk space is below threshold of {2}. Only {0} out of {3} left
     *     on {1}.}
     */
    public static String DiskSpaceMonitorDescriptor_DiskSpace_FreeSpaceTooLow(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("DiskSpaceMonitorDescriptor.DiskSpace.FreeSpaceTooLow", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code DiskSpaceMonitorDescriptor.DiskSpace.FreeSpaceTooLow}:
     * {@code Disk space is below threshold of {2}. Only {0} out of {3} left
     * on {1}.}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Disk space is below threshold of {2}. Only {0} out of {3} left
     *     on {1}.}
     */
    public static Localizable _DiskSpaceMonitorDescriptor_DiskSpace_FreeSpaceTooLow(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "DiskSpaceMonitorDescriptor.DiskSpace.FreeSpaceTooLow", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code ResponseTimeMonitor.DisplayName}: {@code Response Time}.
     * 
     * @return
     *     {@code Response Time}
     */
    public static String ResponseTimeMonitor_DisplayName() {
        return holder.format("ResponseTimeMonitor.DisplayName");
    }

    /**
     * Key {@code ResponseTimeMonitor.DisplayName}: {@code Response Time}.
     * 
     * @return
     *     {@code Response Time}
     */
    public static Localizable _ResponseTimeMonitor_DisplayName() {
        return new Localizable(holder, "ResponseTimeMonitor.DisplayName");
    }

    /**
     * Key {@code ClockMonitor.DisplayName}: {@code Clock Difference}.
     * 
     * @return
     *     {@code Clock Difference}
     */
    public static String ClockMonitor_DisplayName() {
        return holder.format("ClockMonitor.DisplayName");
    }

    /**
     * Key {@code ClockMonitor.DisplayName}: {@code Clock Difference}.
     * 
     * @return
     *     {@code Clock Difference}
     */
    public static Localizable _ClockMonitor_DisplayName() {
        return new Localizable(holder, "ClockMonitor.DisplayName");
    }

    /**
     * Key {@code AbstractNodeMonitorDescriptor.NoDataYet}: {@code Not yet}.
     * 
     * @return
     *     {@code Not yet}
     */
    public static String AbstractNodeMonitorDescriptor_NoDataYet() {
        return holder.format("AbstractNodeMonitorDescriptor.NoDataYet");
    }

    /**
     * Key {@code AbstractNodeMonitorDescriptor.NoDataYet}: {@code Not yet}.
     * 
     * @return
     *     {@code Not yet}
     */
    public static Localizable _AbstractNodeMonitorDescriptor_NoDataYet() {
        return new Localizable(holder, "AbstractNodeMonitorDescriptor.NoDataYet");
    }

    /**
     * Key {@code DiskSpaceMonitor.MarkedOffline}: {@code Making {0} offline
     * temporarily due to the lack of disk space}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Making {0} offline temporarily due to the lack of disk space}
     */
    public static String DiskSpaceMonitor_MarkedOffline(Object arg0) {
        return holder.format("DiskSpaceMonitor.MarkedOffline", arg0);
    }

    /**
     * Key {@code DiskSpaceMonitor.MarkedOffline}: {@code Making {0} offline
     * temporarily due to the lack of disk space}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Making {0} offline temporarily due to the lack of disk space}
     */
    public static Localizable _DiskSpaceMonitor_MarkedOffline(Object arg0) {
        return new Localizable(holder, "DiskSpaceMonitor.MarkedOffline", arg0);
    }

    /**
     * Key {@code SwapSpaceMonitor.DisplayName}: {@code Free Swap Space}.
     * 
     * @return
     *     {@code Free Swap Space}
     */
    public static String SwapSpaceMonitor_DisplayName() {
        return holder.format("SwapSpaceMonitor.DisplayName");
    }

    /**
     * Key {@code SwapSpaceMonitor.DisplayName}: {@code Free Swap Space}.
     * 
     * @return
     *     {@code Free Swap Space}
     */
    public static Localizable _SwapSpaceMonitor_DisplayName() {
        return new Localizable(holder, "SwapSpaceMonitor.DisplayName");
    }

    /**
     * Key {@code MonitorMarkedNodeOffline.DisplayName}: {@code Node Marked
     * Offline Due to Health Check}.
     * 
     * @return
     *     {@code Node Marked Offline Due to Health Check}
     */
    public static String MonitorMarkedNodeOffline_DisplayName() {
        return holder.format("MonitorMarkedNodeOffline.DisplayName");
    }

    /**
     * Key {@code MonitorMarkedNodeOffline.DisplayName}: {@code Node Marked
     * Offline Due to Health Check}.
     * 
     * @return
     *     {@code Node Marked Offline Due to Health Check}
     */
    public static Localizable _MonitorMarkedNodeOffline_DisplayName() {
        return new Localizable(holder, "MonitorMarkedNodeOffline.DisplayName");
    }

}
