// CHECKSTYLE:OFF

package jenkins.tasks.filters.impl;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code RetainVariablesLocalRule_RESET_DisplayName}: {@code Reset
     * to default value}.
     * 
     * @return
     *     {@code Reset to default value}
     */
    public static String RetainVariablesLocalRule_RESET_DisplayName() {
        return holder.format("RetainVariablesLocalRule_RESET_DisplayName");
    }

    /**
     * Key {@code RetainVariablesLocalRule_RESET_DisplayName}: {@code Reset
     * to default value}.
     * 
     * @return
     *     {@code Reset to default value}
     */
    public static Localizable _RetainVariablesLocalRule_RESET_DisplayName() {
        return new Localizable(holder, "RetainVariablesLocalRule_RESET_DisplayName");
    }

    /**
     * Key {@code RetainVariablesLocalRule.RemovalMessage}: {@code The
     * following environment variables were removed by ''{0}'': {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The following environment variables were removed by ''{0}'':
     *     {1}}
     */
    public static String RetainVariablesLocalRule_RemovalMessage(Object arg0, Object arg1) {
        return holder.format("RetainVariablesLocalRule.RemovalMessage", arg0, arg1);
    }

    /**
     * Key {@code RetainVariablesLocalRule.RemovalMessage}: {@code The
     * following environment variables were removed by ''{0}'': {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The following environment variables were removed by ''{0}'':
     *     {1}}
     */
    public static Localizable _RetainVariablesLocalRule_RemovalMessage(Object arg0, Object arg1) {
        return new Localizable(holder, "RetainVariablesLocalRule.RemovalMessage", arg0, arg1);
    }

    /**
     * Key {@code RetainVariablesLocalRule.DisplayName}: {@code Only Keep
     * Specified Environment Variables}.
     * 
     * @return
     *     {@code Only Keep Specified Environment Variables}
     */
    public static String RetainVariablesLocalRule_DisplayName() {
        return holder.format("RetainVariablesLocalRule.DisplayName");
    }

    /**
     * Key {@code RetainVariablesLocalRule.DisplayName}: {@code Only Keep
     * Specified Environment Variables}.
     * 
     * @return
     *     {@code Only Keep Specified Environment Variables}
     */
    public static Localizable _RetainVariablesLocalRule_DisplayName() {
        return new Localizable(holder, "RetainVariablesLocalRule.DisplayName");
    }

    /**
     * Key {@code
     * RetainVariablesLocalRule.CharacteristicEnvVarsFormValidationOK}:
     * {@code In addition to any environment variables listed above, Jenkins
     * will also retain environment variables it needs to identify and kill
     * runaway processes when the build is done.}.
     * 
     * @return
     *     {@code In addition to any environment variables listed above, Jenkins
     *     will also retain environment variables it needs to identify and kill
     *     runaway processes when the build is done.}
     */
    public static String RetainVariablesLocalRule_CharacteristicEnvVarsFormValidationOK() {
        return holder.format("RetainVariablesLocalRule.CharacteristicEnvVarsFormValidationOK");
    }

    /**
     * Key {@code
     * RetainVariablesLocalRule.CharacteristicEnvVarsFormValidationOK}:
     * {@code In addition to any environment variables listed above, Jenkins
     * will also retain environment variables it needs to identify and kill
     * runaway processes when the build is done.}.
     * 
     * @return
     *     {@code In addition to any environment variables listed above, Jenkins
     *     will also retain environment variables it needs to identify and kill
     *     runaway processes when the build is done.}
     */
    public static Localizable _RetainVariablesLocalRule_CharacteristicEnvVarsFormValidationOK() {
        return new Localizable(holder, "RetainVariablesLocalRule.CharacteristicEnvVarsFormValidationOK");
    }

    /**
     * Key {@code RetainVariablesLocalRule.ResetMessage}: {@code The
     * following environment variables were reset to their system default
     * value by ''{0}'': {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The following environment variables were reset to their system
     *     default value by ''{0}'': {1}}
     */
    public static String RetainVariablesLocalRule_ResetMessage(Object arg0, Object arg1) {
        return holder.format("RetainVariablesLocalRule.ResetMessage", arg0, arg1);
    }

    /**
     * Key {@code RetainVariablesLocalRule.ResetMessage}: {@code The
     * following environment variables were reset to their system default
     * value by ''{0}'': {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The following environment variables were reset to their system
     *     default value by ''{0}'': {1}}
     */
    public static Localizable _RetainVariablesLocalRule_ResetMessage(Object arg0, Object arg1) {
        return new Localizable(holder, "RetainVariablesLocalRule.ResetMessage", arg0, arg1);
    }

    /**
     * Key {@code
     * RetainVariablesLocalRule.CharacteristicEnvVarsFormValidationWarning}:
     * {@code It is recommended to retain characteristic environment
     * variables, because Jenkins uses them to identify and kill runaway
     * processes after a build is finished.}.
     * 
     * @return
     *     {@code It is recommended to retain characteristic environment
     *     variables, because Jenkins uses them to identify and kill runaway
     *     processes after a build is finished.}
     */
    public static String RetainVariablesLocalRule_CharacteristicEnvVarsFormValidationWarning() {
        return holder.format("RetainVariablesLocalRule.CharacteristicEnvVarsFormValidationWarning");
    }

    /**
     * Key {@code
     * RetainVariablesLocalRule.CharacteristicEnvVarsFormValidationWarning}:
     * {@code It is recommended to retain characteristic environment
     * variables, because Jenkins uses them to identify and kill runaway
     * processes after a build is finished.}.
     * 
     * @return
     *     {@code It is recommended to retain characteristic environment
     *     variables, because Jenkins uses them to identify and kill runaway
     *     processes after a build is finished.}
     */
    public static Localizable _RetainVariablesLocalRule_CharacteristicEnvVarsFormValidationWarning() {
        return new Localizable(holder, "RetainVariablesLocalRule.CharacteristicEnvVarsFormValidationWarning");
    }

    /**
     * Key {@code RetainVariablesLocalRule_REMOVE_DisplayName}: {@code Remove
     * from environment}.
     * 
     * @return
     *     {@code Remove from environment}
     */
    public static String RetainVariablesLocalRule_REMOVE_DisplayName() {
        return holder.format("RetainVariablesLocalRule_REMOVE_DisplayName");
    }

    /**
     * Key {@code RetainVariablesLocalRule_REMOVE_DisplayName}: {@code Remove
     * from environment}.
     * 
     * @return
     *     {@code Remove from environment}
     */
    public static Localizable _RetainVariablesLocalRule_REMOVE_DisplayName() {
        return new Localizable(holder, "RetainVariablesLocalRule_REMOVE_DisplayName");
    }

}
