/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.Util;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import jenkins.model.Jenkins;
import jenkins.security.ImpersonatingUserDetailsService2;
import jenkins.security.SecurityListener;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.userdetails.UserDetails;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public abstract class AbstractPasswordBasedSecurityRealm
extends SecurityRealm {
    @Override
    public SecurityRealm.SecurityComponents createSecurityComponents() {
        Authenticator authenticator = new Authenticator();
        RememberMeAuthenticationProvider rmap = new RememberMeAuthenticationProvider(Jenkins.get().getSecretKey());
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider("anonymous");
        ProviderManager authenticationManager = new ProviderManager(new AuthenticationProvider[]{authenticator, rmap, aap});
        return new SecurityRealm.SecurityComponents((AuthenticationManager)authenticationManager, new ImpersonatingUserDetailsService2(this::loadUserByUsername2));
    }

    protected org.springframework.security.core.userdetails.UserDetails authenticate2(String username, String password) throws AuthenticationException {
        if (Util.isOverridden(AbstractPasswordBasedSecurityRealm.class, this.getClass(), "authenticate", String.class, String.class)) {
            try {
                return this.authenticate(username, password).toSpring();
            }
            catch (AcegiSecurityException x) {
                throw x.toSpring();
            }
        }
        throw new AbstractMethodError("Implement authenticate2");
    }

    @Deprecated
    protected UserDetails authenticate(String username, String password) throws org.acegisecurity.AuthenticationException {
        try {
            return UserDetails.fromSpring(this.authenticate2(username, password));
        }
        catch (AuthenticationException x) {
            throw org.acegisecurity.AuthenticationException.fromSpring(x);
        }
    }

    private org.springframework.security.core.userdetails.UserDetails doAuthenticate(String username, String password) throws AuthenticationException {
        try {
            org.springframework.security.core.userdetails.UserDetails user = this.authenticate2(username, password);
            SecurityListener.fireAuthenticated2(user);
            return user;
        }
        catch (AuthenticationException x) {
            SecurityListener.fireFailedToAuthenticate(username);
            throw x;
        }
    }

    @Override
    public org.springframework.security.core.userdetails.UserDetails loadUserByUsername2(String username) throws UsernameNotFoundException {
        if (Util.isOverridden(AbstractPasswordBasedSecurityRealm.class, this.getClass(), "loadUserByUsername", String.class)) {
            try {
                return this.loadUserByUsername(username).toSpring();
            }
            catch (AcegiSecurityException x) {
                throw x.toSpring();
            }
            catch (DataAccessException x) {
                throw x.toSpring();
            }
        }
        throw new AbstractMethodError("Implement loadUserByUsername2");
    }

    @Override
    @Deprecated
    public UserDetails loadUserByUsername(String username) throws org.acegisecurity.userdetails.UsernameNotFoundException, DataAccessException {
        try {
            return UserDetails.fromSpring(this.loadUserByUsername2(username));
        }
        catch (AuthenticationException x) {
            throw org.acegisecurity.AuthenticationException.fromSpring(x);
        }
    }

    @Override
    public GroupDetails loadGroupByGroupname2(String groupname, boolean fetchMembers) throws UsernameNotFoundException {
        if (Util.isOverridden(AbstractPasswordBasedSecurityRealm.class, this.getClass(), "loadGroupByGroupname", String.class)) {
            try {
                return this.loadGroupByGroupname(groupname);
            }
            catch (AcegiSecurityException x) {
                throw x.toSpring();
            }
            catch (DataAccessException x) {
                throw x.toSpring();
            }
        }
        throw new AbstractMethodError("Implement loadGroupByGroupname2");
    }

    @Override
    @Deprecated
    public GroupDetails loadGroupByGroupname(String groupname) throws org.acegisecurity.userdetails.UsernameNotFoundException, DataAccessException {
        try {
            return this.loadGroupByGroupname2(groupname, false);
        }
        catch (AuthenticationException x) {
            throw org.acegisecurity.AuthenticationException.fromSpring(x);
        }
    }

    class Authenticator
    extends AbstractUserDetailsAuthenticationProvider {
        Authenticator() {
        }

        protected void additionalAuthenticationChecks(org.springframework.security.core.userdetails.UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        }

        protected org.springframework.security.core.userdetails.UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
            return AbstractPasswordBasedSecurityRealm.this.doAuthenticate(username, authentication.getCredentials().toString());
        }
    }
}

