/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.experimentalflags;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.experimentalflags.Messages;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class UserExperimentalFlagsProperty
extends UserProperty {
    private Map<String, String> flags = new HashMap<String, String>();

    @DataBoundConstructor
    public UserExperimentalFlagsProperty() {
    }

    public UserExperimentalFlagsProperty(Map<String, String> flags) {
        this.flags = new HashMap<String, String>(flags);
    }

    @CheckForNull
    public Object getFlagValue(String flagKey) {
        return this.flags.get(flagKey);
    }

    @Extension(ordinal=-500.0)
    @Symbol(value={"experimentalFlags"})
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.UserExperimentalFlagsProperty_DisplayName();
        }

        @Override
        @NonNull
        public UserProperty newInstance(User user) {
            return new UserExperimentalFlagsProperty();
        }

        @Override
        public UserProperty newInstance(@Nullable StaplerRequest req, @NonNull JSONObject formData) throws Descriptor.FormException {
            JSONObject flagsObj = formData.getJSONObject("flags");
            HashMap<String, String> flags = new HashMap<String, String>();
            for (Object key : flagsObj.keySet()) {
                String value = (String)flagsObj.get((String)key);
                if (value.isEmpty()) continue;
                flags.put((String)key, value);
            }
            return new UserExperimentalFlagsProperty(flags);
        }
    }
}

