/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.TaskListener;
import hudson.util.HttpResponses;
import hudson.util.SecretRewriter;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.management.AsynchronousAdministrativeMonitor;
import jenkins.model.Jenkins;
import jenkins.security.Messages;
import jenkins.util.io.FileBoolean;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"rekeySecret"})
public class RekeySecretAdminMonitor
extends AsynchronousAdministrativeMonitor {
    private final FileBoolean needed = this.state("needed");
    private final FileBoolean done = this.state("done");
    private final FileBoolean scanOnBoot = this.state("scanOnBoot");
    private static final Logger LOGGER = Logger.getLogger(RekeySecretAdminMonitor.class.getName());

    public RekeySecretAdminMonitor() throws IOException {
        Jenkins j = Jenkins.get();
        if (j.isUpgradedFromBefore(new VersionNumber("1.496.*")) && new FileBoolean(new File(j.getRootDir(), "secret.key.not-so-secret")).isOff()) {
            this.needed.on();
        }
        Util.deleteRecursive(new File(this.getBaseDir(), "backups"));
    }

    @Override
    public boolean isActivated() {
        return this.needed.isOn();
    }

    public boolean isDone() {
        return this.done.isOn();
    }

    public void setNeeded() {
        this.needed.on();
    }

    public boolean isScanOnBoot() {
        return this.scanOnBoot.isOn();
    }

    @Override
    public boolean isSecurity() {
        return true;
    }

    @RequirePOST
    public HttpResponse doScan(StaplerRequest req) throws IOException, GeneralSecurityException {
        if (req.hasParameter("background")) {
            this.start(false);
        } else if (req.hasParameter("schedule")) {
            this.scanOnBoot.on();
        } else if (req.hasParameter("dismiss")) {
            this.disable(true);
        } else {
            throw HttpResponses.error((int)400, (String)("Invalid request submission: " + req.getParameterMap()));
        }
        return HttpResponses.redirectViaContextPath((String)"/manage");
    }

    private FileBoolean state(String name) {
        return new FileBoolean(new File(this.getBaseDir(), name));
    }

    @Initializer(fatal=false, after=InitMilestone.PLUGINS_STARTED, before=InitMilestone.EXTENSIONS_AUGMENTED)
    public void scanOnReboot() throws InterruptedException, IOException, GeneralSecurityException {
        FileBoolean flag = this.scanOnBoot;
        if (flag.isOn()) {
            flag.off();
            this.start(false).join();
        }
    }

    @Override
    public String getDisplayName() {
        return Messages.RekeySecretAdminMonitor_DisplayName();
    }

    @Override
    protected File getLogFile() {
        return new File(this.getBaseDir(), "rekey.log");
    }

    @Override
    protected void fix(TaskListener listener) throws Exception {
        LOGGER.info("Initiating a re-keying of secrets. See " + this.getLogFile());
        SecretRewriter rewriter = new SecretRewriter();
        try {
            PrintStream log = listener.getLogger();
            log.println("Started re-keying " + new Date());
            int count = rewriter.rewriteRecursive(Jenkins.get().getRootDir(), listener);
            log.printf("Completed re-keying %d files on %s%n", count, new Date());
            new RekeySecretAdminMonitor().done.on();
            LOGGER.info("Secret re-keying completed");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Fatal failure in re-keying secrets", e);
            Functions.printStackTrace((Throwable)e, listener.error("Fatal failure in rewriting secrets"));
        }
    }
}

