/*
 * Decompiled with CFR 0.152.
 */
package jenkins.widgets;

import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractItem;
import hudson.model.BallColor;
import hudson.model.Run;
import java.util.Date;
import jenkins.console.ConsoleUrlProvider;
import jenkins.widgets.RunListProgressiveRendering;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

@Restricted(value={DoNotUse.class})
public class BuildListTable
extends RunListProgressiveRendering {
    @Override
    protected void calculate(Run<?, ?> build, JSONObject element) {
        BallColor iconColor = build.getIconColor();
        element.put("iconColorOrdinal", (Object)iconColor.ordinal());
        element.put("iconColorDescription", (Object)iconColor.getDescription());
        element.put("url", (Object)build.getUrl());
        element.put("consoleUrl", (Object)ConsoleUrlProvider.getRedirectUrl(build));
        element.put("iconName", (Object)build.getIconColor().getIconName());
        element.put("parentUrl", (Object)((AbstractItem)build.getParent()).getUrl());
        element.put("parentFullDisplayName", (Object)Functions.breakableString(Functions.escape(((AbstractItem)build.getParent()).getFullDisplayName())));
        element.put("displayName", (Object)build.getDisplayName());
        element.put("timestampString", (Object)build.getTimestampString());
        element.put("timestampString2", (Object)build.getTimestampString2());
        element.put("timestampString3", (Object)Util.XS_DATETIME_FORMATTER.format(new Date(build.getStartTimeInMillis())));
        Run.Summary buildStatusSummary = build.getBuildStatusSummary();
        element.put("buildStatusSummaryWorse", (Object)buildStatusSummary.isWorse);
        element.put("buildStatusSummaryMessage", (Object)buildStatusSummary.message);
    }
}

