/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import com.jcraft.jzlib.GZIPInputStream;
import com.jcraft.jzlib.GZIPOutputStream;
import hudson.ExtensionPoint;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.model.Describable;
import hudson.remoting.ClassFilter;
import hudson.remoting.ObjectInputStreamEx;
import hudson.util.IOUtils;
import hudson.util.UnbufferedBase64InputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.security.HMACConfidentialKey;
import jenkins.util.SystemProperties;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;

public abstract class ConsoleNote<T>
implements Serializable,
Describable<ConsoleNote<?>>,
ExtensionPoint {
    private static final HMACConfidentialKey MAC = new HMACConfidentialKey(ConsoleNote.class, "MAC");
    static boolean INSECURE = SystemProperties.getBoolean(ConsoleNote.class.getName() + ".INSECURE");
    private static final long serialVersionUID = 1L;
    public static final String PREAMBLE_STR = "\u001b[8mha:";
    public static final String POSTAMBLE_STR = "\u001b[0m";
    public static final byte[] PREAMBLE = "\u001b[8mha:".getBytes();
    public static final byte[] POSTAMBLE = "\u001b[0m".getBytes();

    public abstract ConsoleAnnotator annotate(T var1, MarkupText var2, int var3);

    public ConsoleAnnotationDescriptor getDescriptor() {
        return (ConsoleAnnotationDescriptor)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public void encodeTo(OutputStream out) throws IOException {
        out.write(this.encodeToBytes().toByteArray());
    }

    public void encodeTo(Writer out) throws IOException {
        out.write(this.encodeToBytes().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream encodeToBytes() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new GZIPOutputStream((OutputStream)buf));){
            oos.writeObject(this);
        }
        ByteArrayOutputStream buf2 = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream((OutputStream)new Base64OutputStream((OutputStream)buf2, true, -1, null));){
            buf2.write(PREAMBLE);
            if (Jenkins.getInstanceOrNull() != null) {
                byte[] mac = MAC.mac(buf.toByteArray());
                dos.writeInt(-mac.length);
                dos.write(mac);
            }
            dos.writeInt(buf.size());
            buf.writeTo((OutputStream)dos);
        }
        buf2.write(POSTAMBLE);
        return buf2;
    }

    public String encode() throws IOException {
        return this.encodeToBytes().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConsoleNote readFrom(DataInputStream in) throws IOException, ClassNotFoundException {
        try {
            int sz;
            byte[] mac;
            byte[] preamble = new byte[PREAMBLE.length];
            in.readFully(preamble);
            if (!Arrays.equals(preamble, PREAMBLE)) {
                return null;
            }
            DataInputStream decoded = new DataInputStream(new UnbufferedBase64InputStream(in));
            int macSz = -decoded.readInt();
            if (macSz > 0) {
                mac = new byte[macSz];
                decoded.readFully(mac);
                sz = decoded.readInt();
            } else {
                mac = null;
                sz = -macSz;
            }
            byte[] buf = new byte[sz];
            decoded.readFully(buf);
            byte[] postamble = new byte[POSTAMBLE.length];
            in.readFully(postamble);
            if (!Arrays.equals(postamble, POSTAMBLE)) {
                return null;
            }
            if (mac == null) {
                if (!INSECURE) {
                    throw new IOException("Refusing to deserialize unsigned note from an old log.");
                }
            } else if (!MAC.checkMac(buf, mac)) {
                throw new IOException("MAC mismatch");
            }
            Jenkins jenkins = Jenkins.getInstance();
            try (ObjectInputStreamEx ois = new ObjectInputStreamEx((InputStream)new GZIPInputStream((InputStream)new ByteArrayInputStream(buf)), jenkins != null ? jenkins.pluginManager.uberClassLoader : ConsoleNote.class.getClassLoader(), ClassFilter.DEFAULT);){
                ConsoleNote consoleNote = (ConsoleNote)ois.readObject();
                return consoleNote;
            }
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    public static void skip(DataInputStream in) throws IOException {
        int sz;
        byte[] preamble = new byte[PREAMBLE.length];
        in.readFully(preamble);
        if (!Arrays.equals(preamble, PREAMBLE)) {
            return;
        }
        DataInputStream decoded = new DataInputStream(new UnbufferedBase64InputStream(in));
        int macSz = -decoded.readInt();
        if (macSz > 0) {
            IOUtils.skip(decoded, macSz);
            sz = decoded.readInt();
            IOUtils.skip(decoded, sz);
        } else {
            sz = -macSz;
            IOUtils.skip(decoded, sz);
        }
        byte[] postamble = new byte[POSTAMBLE.length];
        in.readFully(postamble);
    }

    public static int findPreamble(byte[] buf, int start, int len) {
        int e = start + len - PREAMBLE.length + 1;
        block0: for (int i = start; i < e; ++i) {
            if (buf[i] != PREAMBLE[0]) continue;
            for (int j = 1; j < PREAMBLE.length; ++j) {
                if (buf[i + j] != PREAMBLE[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static List<String> removeNotes(Collection<String> logLines) {
        ArrayList<String> r = new ArrayList<String>(logLines.size());
        for (String l : logLines) {
            r.add(ConsoleNote.removeNotes(l));
        }
        return r;
    }

    public static String removeNotes(String line) {
        int idx;
        while ((idx = line.indexOf(PREAMBLE_STR)) >= 0) {
            int e = line.indexOf(POSTAMBLE_STR, idx);
            if (e < 0) {
                return line;
            }
            line = line.substring(0, idx) + line.substring(e + POSTAMBLE_STR.length());
        }
        return line;
    }
}

