/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import hudson.console.ConsoleNote;
import hudson.console.LineTransformationOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class PlainTextConsoleOutputStream
extends LineTransformationOutputStream {
    private final OutputStream out;
    private static final Logger LOGGER = Logger.getLogger(PlainTextConsoleOutputStream.class.getName());

    public PlainTextConsoleOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    protected void eol(byte[] in, int sz) throws IOException {
        int next = ConsoleNote.findPreamble(in, 0, sz);
        int written = 0;
        while (next >= 0) {
            if (next > written) {
                this.out.write(in, written, next - written);
                written = next;
            } else assert (next == written);
            int rest = sz - next;
            ByteArrayInputStream b = new ByteArrayInputStream(in, next, rest);
            ConsoleNote.skip(new DataInputStream(b));
            int bytesUsed = rest - b.available();
            next = ConsoleNote.findPreamble(in, written += bytesUsed, sz - written);
        }
        this.out.write(in, written, sz - written);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.out.close();
    }
}

