/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Messages;
import hudson.model.TopLevelItem;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.jelly.DefaultScriptInvoker;
import org.kohsuke.stapler.jelly.JellyClassTearOff;

public abstract class TopLevelItemDescriptor
extends Descriptor<TopLevelItem>
implements IconSpec {
    private static final Logger LOGGER = Logger.getLogger(TopLevelItemDescriptor.class.getName());

    protected TopLevelItemDescriptor(Class<? extends TopLevelItem> clazz) {
        super(clazz);
    }

    protected TopLevelItemDescriptor() {
    }

    public boolean isApplicable(Descriptor descriptor) {
        return true;
    }

    public boolean isApplicableIn(ItemGroup parent) {
        return true;
    }

    public final void checkApplicableIn(ItemGroup parent) {
        if (!this.isApplicableIn(parent)) {
            throw new AccessDeniedException(Messages.TopLevelItemDescriptor_NotApplicableIn(this.getDisplayName(), parent.getFullDisplayName()));
        }
    }

    public boolean testInstance(TopLevelItem i) {
        return this.clazz.isInstance(i);
    }

    @Override
    public String getDisplayName() {
        return super.getDisplayName();
    }

    @Nonnull
    public String getDescription() {
        Stapler stapler = Stapler.getCurrent();
        if (stapler != null) {
            try {
                WebApp webapp = WebApp.getCurrent();
                MetaClass meta = webapp.getMetaClass((Object)this);
                Script s = (Script)((JellyClassTearOff)meta.loadTearOff(JellyClassTearOff.class)).findScript("newInstanceDetail");
                if (s == null) {
                    return "";
                }
                DefaultScriptInvoker dsi = new DefaultScriptInvoker();
                StringWriter sw = new StringWriter();
                XMLOutput xml = dsi.createXMLOutput((Writer)sw, true);
                dsi.invokeScript(Stapler.getCurrentRequest(), Stapler.getCurrentResponse(), s, (Object)this, xml);
                return sw.toString();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, null, e);
                return "";
            }
        }
        return "";
    }

    @Nonnull
    public String getCategoryId() {
        return "uncategorized";
    }

    @CheckForNull
    @Deprecated
    public String getIconFilePathPattern() {
        return null;
    }

    @CheckForNull
    @Deprecated
    public String getIconFilePath(String size) {
        if (!StringUtils.isBlank((String)this.getIconFilePathPattern())) {
            return this.getIconFilePathPattern().replace(":size", size);
        }
        return null;
    }

    public String getIconClassName() {
        String pattern = this.getIconFilePathPattern();
        if (pattern != null) {
            Icon icon;
            String path = pattern.replace(":size", "24x24");
            if (path.indexOf(47) == -1) {
                return IconSet.toNormalizedIconNameClass((Object)path);
            }
            if (Jenkins.RESOURCE_PATH.length() > 0 && path.startsWith(Jenkins.RESOURCE_PATH)) {
                path = path.substring(Jenkins.RESOURCE_PATH.length());
            }
            if ((icon = IconSet.icons.getIconByUrl((Object)path)) != null) {
                return icon.getClassSpec().replaceAll("\\s*icon-md\\s*", " ").replaceAll("\\s+", " ");
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public TopLevelItem newInstance(StaplerRequest req) throws Descriptor.FormException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public TopLevelItem newInstance(String name) {
        return this.newInstance(Jenkins.getInstance(), name);
    }

    public abstract TopLevelItem newInstance(ItemGroup var1, String var2);

    public static ExtensionList<TopLevelItemDescriptor> all() {
        return Items.all();
    }
}

