/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.RestrictedSince;
import hudson.model.Descriptor;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public abstract class DelegatingComputerLauncher
extends ComputerLauncher {
    protected ComputerLauncher launcher;

    protected DelegatingComputerLauncher(ComputerLauncher launcher) {
        this.launcher = launcher;
    }

    public ComputerLauncher getLauncher() {
        return this.launcher;
    }

    @Override
    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        this.getLauncher().launch(computer, listener);
    }

    @Override
    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        this.getLauncher().afterDisconnect(computer, listener);
    }

    @Override
    public void beforeDisconnect(SlaveComputer computer, TaskListener listener) {
        this.getLauncher().beforeDisconnect(computer, listener);
    }

    public static abstract class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public List<Descriptor<ComputerLauncher>> applicableDescriptors(@CheckForNull Slave it, @Nonnull Slave.SlaveDescriptor itDescriptor) {
            ArrayList<Descriptor<ComputerLauncher>> r = new ArrayList<Descriptor<ComputerLauncher>>();
            for (Descriptor<ComputerLauncher> d : itDescriptor.computerLauncherDescriptors(it)) {
                if (DelegatingComputerLauncher.class.isAssignableFrom(d.getKlass().toJavaClass())) continue;
                r.add(d);
            }
            return r;
        }

        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.12")
        public List<Descriptor<ComputerLauncher>> getApplicableDescriptors() {
            ArrayList<Descriptor<ComputerLauncher>> r = new ArrayList<Descriptor<ComputerLauncher>>();
            for (Descriptor d : Jenkins.getInstance().getDescriptorList(ComputerLauncher.class)) {
                if (DelegatingComputerLauncher.class.isAssignableFrom(d.getKlass().toJavaClass())) continue;
                r.add(d);
            }
            return r;
        }
    }
}

