/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import hudson.Functions;
import hudson.os.PosixException;
import hudson.util.IOUtils;
import hudson.util.io.Archiver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.BoundedInputStream;

final class TarArchiver
extends Archiver {
    private final byte[] buf = new byte[8192];
    private final TarArchiveOutputStream tar;

    TarArchiver(OutputStream out) {
        this.tar = new TarArchiveOutputStream(out);
        this.tar.setBigNumberMode(1);
        this.tar.setLongFileMode(2);
    }

    @Override
    public void visitSymlink(File link, String target, String relativePath) throws IOException {
        TarArchiveEntry e = new TarArchiveEntry(relativePath, 50);
        try {
            int mode = IOUtils.mode(link);
            if (mode != -1) {
                e.setMode(mode);
            }
        }
        catch (PosixException x) {
            // empty catch block
        }
        e.setLinkName(target);
        this.tar.putArchiveEntry((ArchiveEntry)e);
        this.tar.closeArchiveEntry();
        ++this.entriesWritten;
    }

    @Override
    public boolean understandsSymlink() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(File file, String relativePath) throws IOException {
        block34: {
            if (Functions.isWindows()) {
                relativePath = relativePath.replace('\\', '/');
            }
            if (file.isDirectory()) {
                relativePath = relativePath + '/';
            }
            TarArchiveEntry te = new TarArchiveEntry(relativePath);
            int mode = IOUtils.mode(file);
            if (mode != -1) {
                te.setMode(mode);
            }
            te.setModTime(file.lastModified());
            long size = 0L;
            if (!file.isDirectory()) {
                size = file.length();
                te.setSize(size);
            }
            this.tar.putArchiveEntry((ArchiveEntry)te);
            try {
                if (file.isDirectory()) break block34;
                try (FileInputStream fin = new FileInputStream(file);
                     BoundedInputStream in = new BoundedInputStream((InputStream)fin, size);){
                    int len;
                    while ((len = in.read(this.buf)) >= 0) {
                        this.tar.write(this.buf, 0, len);
                    }
                }
                catch (IOException e) {
                    IOException ioE = new IOException("Error writing to tar file from: " + file, e);
                    throw ioE;
                }
            }
            finally {
                this.tar.closeArchiveEntry();
            }
        }
        ++this.entriesWritten;
    }

    @Override
    public void close() throws IOException {
        this.tar.close();
    }
}

