/*
 * Decompiled with CFR 0.152.
 */
package jenkins;

import hudson.remoting.ChannelProperty;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.FilePathFilter;

class FilePathFilterAggregator
extends FilePathFilter {
    private final CopyOnWriteArrayList<Entry> all = new CopyOnWriteArrayList();
    static final ChannelProperty<FilePathFilterAggregator> KEY = new ChannelProperty(FilePathFilterAggregator.class, "FilePathFilters");
    public static final int DEFAULT_ORDINAL = 0;

    FilePathFilterAggregator() {
    }

    public final void add(FilePathFilter f) {
        this.add(f, 0.0);
    }

    public void add(FilePathFilter f, double ordinal) {
        Entry e = new Entry(f, ordinal);
        int i = Collections.binarySearch(this.all, e, Collections.reverseOrder());
        if (i >= 0) {
            this.all.add(i, e);
        } else {
            this.all.add(-i - 1, e);
        }
    }

    public void remove(FilePathFilter f) {
        for (Entry e : this.all) {
            if (e.filter != f) continue;
            this.all.remove(e);
        }
    }

    protected boolean defaultAction() throws SecurityException {
        return false;
    }

    @Override
    public boolean read(File f) throws SecurityException {
        for (Entry e : this.all) {
            if (!e.filter.read(f)) continue;
            return true;
        }
        return this.defaultAction();
    }

    @Override
    public boolean mkdirs(File f) throws SecurityException {
        for (Entry e : this.all) {
            if (!e.filter.mkdirs(f)) continue;
            return true;
        }
        return this.defaultAction();
    }

    @Override
    public boolean write(File f) throws SecurityException {
        for (Entry e : this.all) {
            if (!e.filter.write(f)) continue;
            return true;
        }
        return this.defaultAction();
    }

    @Override
    public boolean symlink(File f) throws SecurityException {
        for (Entry e : this.all) {
            if (!e.filter.symlink(f)) continue;
            return true;
        }
        return this.defaultAction();
    }

    @Override
    public boolean create(File f) throws SecurityException {
        for (Entry e : this.all) {
            if (!e.filter.create(f)) continue;
            return true;
        }
        return this.defaultAction();
    }

    @Override
    public boolean delete(File f) throws SecurityException {
        for (Entry e : this.all) {
            if (!e.filter.delete(f)) continue;
            return true;
        }
        return this.defaultAction();
    }

    @Override
    public boolean stat(File f) throws SecurityException {
        for (Entry e : this.all) {
            if (!e.filter.stat(f)) continue;
            return true;
        }
        return this.defaultAction();
    }

    public String toString() {
        return "FilePathFilterAggregator" + this.all;
    }

    private class Entry
    implements Comparable<Entry> {
        final FilePathFilter filter;
        final double ordinal;

        private Entry(FilePathFilter filter, double ordinal) {
            this.filter = filter;
            this.ordinal = ordinal;
        }

        @Override
        public int compareTo(Entry that) {
            double d = this.ordinal - that.ordinal;
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return this.filter.getClass().getName().compareTo(that.filter.getClass().getName());
        }
    }
}

