/*
 * Decompiled with CFR 0.152.
 */
package jenkins.diagnostics;

import hudson.Extension;
import hudson.Util;
import hudson.model.AdministrativeMonitor;
import hudson.util.FormValidation;
import java.io.IOException;
import jenkins.diagnostics.Messages;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Restricted(value={NoExternalUse.class})
public class URICheckEncodingMonitor
extends AdministrativeMonitor {
    public boolean isCheckEnabled() {
        return !"ISO-8859-1".equalsIgnoreCase(System.getProperty("file.encoding"));
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return Messages.URICheckEncodingMonitor_DisplayName();
    }

    public FormValidation doCheckURIEncoding(StaplerRequest request) throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        String expected = "\u57f7\u4e8b";
        String value = Util.fixEmpty(request.getParameter("value"));
        if (!"\u57f7\u4e8b".equals(value)) {
            return FormValidation.warningWithMarkup(hudson.model.Messages.Hudson_NotUsesUTF8ToDecodeURL());
        }
        return FormValidation.ok();
    }
}

