/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.lazy;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import jenkins.model.lazy.AbstractLazyLoadRunMap;
import jenkins.model.lazy.BuildReferenceMapAdapter;

class LazyLoadRunMapEntrySet<R>
extends AbstractSet<Map.Entry<Integer, R>> {
    private final AbstractLazyLoadRunMap<R> owner;
    private Set<Map.Entry<Integer, R>> all;

    LazyLoadRunMapEntrySet(AbstractLazyLoadRunMap<R> owner) {
        this.owner = owner;
    }

    private synchronized Set<Map.Entry<Integer, R>> all() {
        if (this.all == null) {
            this.all = new BuildReferenceMapAdapter<R>(this.owner, this.owner.all()).entrySet();
        }
        return this.all;
    }

    synchronized void clearCache() {
        this.all = null;
    }

    @Override
    public int size() {
        return this.all().size();
    }

    @Override
    public boolean isEmpty() {
        return this.owner.newestBuild() == null;
    }

    @Override
    public boolean contains(Object o) {
        Map.Entry e;
        Object k;
        if (o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) instanceof Integer) {
            return this.owner.getByNumber((Integer)k).equals(e.getValue());
        }
        return false;
    }

    @Override
    public Iterator<Map.Entry<Integer, R>> iterator() {
        return new Iterator<Map.Entry<Integer, R>>(){
            R last = null;
            R next = LazyLoadRunMapEntrySet.access$000(LazyLoadRunMapEntrySet.this).newestBuild();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Map.Entry<Integer, R> next() {
                this.last = this.next;
                if (this.last == null) {
                    throw new NoSuchElementException();
                }
                this.next = LazyLoadRunMapEntrySet.this.owner.search(LazyLoadRunMapEntrySet.this.owner.getNumberOf(this.last) - 1, AbstractLazyLoadRunMap.Direction.DESC);
                return this.entryOf(this.last);
            }

            private Map.Entry<Integer, R> entryOf(R r) {
                return new AbstractMap.SimpleImmutableEntry(LazyLoadRunMapEntrySet.this.owner.getNumberOf(r), r);
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new UnsupportedOperationException();
                }
                LazyLoadRunMapEntrySet.this.owner.removeValue(this.last);
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.all().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.all().toArray(a);
    }

    @Override
    public boolean add(Map.Entry<Integer, R> integerREntry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return this.owner.removeValue(e.getValue());
        }
        return false;
    }
}

