/*
 * Decompiled with CFR 0.152.
 */
package jenkins.tools;

import com.google.common.base.Predicate;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.security.Permission;
import hudson.util.FormApply;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.management.Messages;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.tools.ToolConfigurationCategory;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension(ordinal=2.147483427E9)
@Restricted(value={NoExternalUse.class})
public class GlobalToolConfiguration
extends ManagementLink {
    public static Predicate<GlobalConfigurationCategory> FILTER = new Predicate<GlobalConfigurationCategory>(){

        public boolean apply(GlobalConfigurationCategory input) {
            return input instanceof ToolConfigurationCategory;
        }
    };
    private static final Logger LOGGER = Logger.getLogger(GlobalToolConfiguration.class.getName());

    @Override
    public String getIconFileName() {
        return "setting.png";
    }

    @Override
    public String getDisplayName() {
        return Messages.ConfigureTools_DisplayName();
    }

    @Override
    public String getDescription() {
        return Messages.ConfigureTools_Description();
    }

    @Override
    public String getUrlName() {
        return "configureTools";
    }

    @Override
    public Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    @RequirePOST
    public synchronized void doConfigure(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        boolean result = this.configure(req, req.getSubmittedForm());
        LOGGER.log(Level.FINE, "tools saved: " + result);
        FormApply.success(req.getContextPath() + "/manage").generateResponse(req, rsp, null);
    }

    private boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException, IOException {
        Jenkins j = Jenkins.getInstance();
        j.checkPermission(Jenkins.ADMINISTER);
        boolean result = true;
        for (Descriptor d : Functions.getSortedDescriptorsForGlobalConfig(FILTER)) {
            result &= this.configureDescriptor(req, json, d);
        }
        j.save();
        return result;
    }

    private boolean configureDescriptor(StaplerRequest req, JSONObject json, Descriptor<?> d) throws Descriptor.FormException {
        String name = d.getJsonSafeClassName();
        JSONObject js = json.has(name) ? json.getJSONObject(name) : new JSONObject();
        json.putAll((Map)js);
        return d.configure(req, js);
    }
}

