/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import hudson.PluginWrapper;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ResourceBundleUtil {
    private static final Logger logger = Logger.getLogger("jenkins.util.ResourceBundle");
    private static final Map<String, JSONObject> bundles = new ConcurrentHashMap<String, JSONObject>();

    private ResourceBundleUtil() {
    }

    @Nonnull
    public static JSONObject getBundle(@Nonnull String baseName) throws MissingResourceException {
        return ResourceBundleUtil.getBundle(baseName, Locale.getDefault());
    }

    @Nonnull
    public static JSONObject getBundle(@Nonnull String baseName, @Nonnull Locale locale) throws MissingResourceException {
        Jenkins jenkins;
        String bundleKey = baseName + ":" + locale.toString();
        JSONObject bundleJSON = bundles.get(bundleKey);
        if (bundleJSON != null) {
            return bundleJSON;
        }
        ResourceBundle bundle = ResourceBundleUtil.getBundle(baseName, locale, Jenkins.class.getClassLoader());
        if (bundle == null && (jenkins = Jenkins.getInstance()) != null) {
            for (PluginWrapper plugin : jenkins.getPluginManager().getPlugins()) {
                bundle = ResourceBundleUtil.getBundle(baseName, locale, plugin.classLoader);
                if (bundle == null) continue;
                break;
            }
        }
        if (bundle == null) {
            throw new MissingResourceException("Can't find bundle for base name " + baseName + ", locale " + locale, baseName + "_" + locale, "");
        }
        bundleJSON = ResourceBundleUtil.toJSONObject(bundle);
        bundles.put(bundleKey, bundleJSON);
        return bundleJSON;
    }

    @CheckForNull
    private static ResourceBundle getBundle(@Nonnull String baseName, @Nonnull Locale locale, @Nonnull ClassLoader classLoader) {
        try {
            return ResourceBundle.getBundle(baseName, locale, classLoader);
        }
        catch (MissingResourceException e) {
            logger.finer(e.getMessage());
            return null;
        }
    }

    private static JSONObject toJSONObject(@Nonnull ResourceBundle bundle) {
        JSONObject json = new JSONObject();
        for (String key : bundle.keySet()) {
            json.put(key, (Object)bundle.getString(key));
        }
        return json;
    }
}

